/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.content;

import java.io.Serializable;

public final class ContentType
implements Serializable {
    public static final ContentType UNKNOWN = new ContentType("unknown");
    public static final ContentType CMS = new ContentType("cms");
    public static final ContentType PORTLET = new ContentType("portlet");
    private final String value;

    private ContentType(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ContentType) {
            ContentType that = (ContentType)obj;
            return this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        return this.value;
    }

    public static ContentType create(String value) throws IllegalArgumentException {
        if ("portlet".equals(value)) {
            return PORTLET;
        }
        if ("cms".equals(value)) {
            return CMS;
        }
        if ("unknown".equals(value)) {
            return UNKNOWN;
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value for content type accepted");
        }
        return new ContentType(value);
    }
}

