/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.DistributedStateImplMBean;
import org.jboss.logging.Logger;
import org.jboss.system.Registry;

public class DistributedStateImpl
implements DistributedStateImplMBean,
HAPartition.HAPartitionStateTransfer {
    protected static final String SERVICE_NAME = "DistributedState";
    protected static final Class[] set_types = new Class[]{String.class, Serializable.class, Serializable.class};
    protected static final Class[] remove_types = new Class[]{String.class, Serializable.class};
    protected HashMap categories = new HashMap();
    protected HashMap keyListeners = new HashMap();
    protected HAPartition partition;
    protected Logger log;
    protected MBeanServer mbeanServer = null;
    protected String name = null;

    public DistributedStateImpl() {
    }

    public DistributedStateImpl(HAPartition partition, MBeanServer server) {
        this.partition = partition;
        this.mbeanServer = server;
        this.log = Logger.getLogger(this.getClass());
    }

    public void init() throws Exception {
        this.partition.subscribeToStateTransferEvents(SERVICE_NAME, this);
        this.partition.registerRPCHandler(SERVICE_NAME, this);
        this.name = "jboss:service=DistributedState,partitionName=" + this.partition.getPartitionName();
        ObjectName jmxName = new ObjectName(this.name);
        this.mbeanServer.registerMBean(this, jmxName);
        Registry.bind((Object)this.name, (Object)this);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void destroy() throws Exception {
        Registry.unbind((Object)this.name);
        ObjectName jmxName = new ObjectName(this.name);
        this.mbeanServer.unregisterMBean(jmxName);
        this.partition.unsubscribeFromStateTransferEvents(SERVICE_NAME, this);
        this.partition.unregisterRPCHandler(SERVICE_NAME, this);
    }

    public String listContent() throws Exception {
        StringBuffer result = new StringBuffer();
        Collection cats = this.getAllCategories();
        for (String category : cats) {
            Iterator keysIter = this.getAllKeys(category).iterator();
            result.append("-----------------------------------------------\n");
            result.append("Category : ").append(category).append("\n\n");
            result.append("KEY\t:\tVALUE\n");
            while (keysIter.hasNext()) {
                Serializable key = (Serializable)keysIter.next();
                String value = this.get(category, key).toString();
                result.append("'").append(key);
                result.append("'\t:\t'");
                result.append(value);
                result.append("'\n");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public String listXmlContent() throws Exception {
        StringBuffer result = new StringBuffer();
        Collection cats = this.getAllCategories();
        Iterator catsIter = cats.iterator();
        result.append("<DistributedState>\n");
        while (catsIter.hasNext()) {
            String category = (String)catsIter.next();
            Iterator keysIter = this.getAllKeys(category).iterator();
            result.append("\t<Category>\n");
            result.append("\t\t<CategoryName>").append(category).append("</CategoryName>\n");
            while (keysIter.hasNext()) {
                Serializable key = (Serializable)keysIter.next();
                String value = this.get(category, key).toString();
                result.append("\t\t<Entry>\n");
                result.append("\t\t\t<Key>").append(key).append("</Key>\n");
                result.append("\t\t\t<Value>").append(value).append("</Value>\n");
                result.append("\t\t</Entry>\n");
            }
            result.append("\t</Category>\n");
        }
        result.append("</DistributedState>\n");
        return result.toString();
    }

    public void set(String category, Serializable key, Serializable value) throws Exception {
        this.set(category, key, value, true);
    }

    public void set(String category, Serializable key, Serializable value, boolean asynchronousCall) throws Exception {
        Object[] args = new Object[]{category, key, value};
        if (asynchronousCall) {
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_set", args, set_types, true);
        } else {
            this.partition.callMethodOnCluster(SERVICE_NAME, "_set", args, set_types, true);
        }
        this._setInternal(category, key, value);
        this.notifyKeyListeners(category, key, value, true);
    }

    public Serializable remove(String category, Serializable key) throws Exception {
        return this.remove(category, key, true);
    }

    public Serializable remove(String category, Serializable key, boolean asynchronousCall) throws Exception {
        Object[] args = new Object[]{category, key};
        if (asynchronousCall) {
            this.partition.callAsynchMethodOnCluster(SERVICE_NAME, "_remove", args, remove_types, true);
        } else {
            this.partition.callMethodOnCluster(SERVICE_NAME, "_remove", args, remove_types, true);
        }
        Serializable removed = this._removeInternal(category, key);
        this.notifyKeyListenersOfRemove(category, key, removed, true);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable get(String category, Serializable key) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                return null;
            }
            return (Serializable)cat.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllCategories() {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            return Collections.unmodifiableCollection(this.categories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllKeys(String category) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                return null;
            }
            return Collections.unmodifiableCollection(cat.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllValues(String category) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                return null;
            }
            return Collections.unmodifiableCollection(cat.values());
        }
    }

    public void registerDSListenerEx(String category, DistributedState.DSListenerEx subscriber) {
        this.registerListener(category, subscriber);
    }

    public void unregisterDSListenerEx(String category, DistributedState.DSListenerEx subscriber) {
        this.unregisterListener(category, subscriber);
    }

    public void registerDSListener(String category, DistributedState.DSListener subscriber) {
        this.registerListener(category, subscriber);
    }

    public void unregisterDSListener(String category, DistributedState.DSListener subscriber) {
        this.unregisterListener(category, subscriber);
    }

    public void _set(String category, String key, Serializable value) throws Exception {
        this._setInternal(category, (Serializable)((Object)key), value);
        this.notifyKeyListeners(category, (Serializable)((Object)key), value, false);
    }

    public void _set(String category, Serializable key, Serializable value) throws Exception {
        this._setInternal(category, key, value);
        this.notifyKeyListeners(category, key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _setInternal(String category, Serializable key, Serializable value) throws Exception {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap<Serializable, Serializable> cat = (HashMap<Serializable, Serializable>)this.categories.get(category);
            if (cat == null) {
                cat = new HashMap<Serializable, Serializable>();
                this.categories.put(category, cat);
            }
            cat.put(key, value);
        }
    }

    public void _remove(String category, String key) throws Exception {
        Serializable removed = this._removeInternal(category, (Serializable)((Object)key));
        this.notifyKeyListenersOfRemove(category, (Serializable)((Object)key), removed, false);
    }

    public void _remove(String category, Serializable key) throws Exception {
        Serializable removed = this._removeInternal(category, key);
        this.notifyKeyListenersOfRemove(category, key, removed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable _removeInternal(String category, Serializable key) throws Exception {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            HashMap cat = (HashMap)this.categories.get(category);
            if (cat == null) {
                return null;
            }
            Object removed = cat.remove(key);
            if (removed != null && cat.size() == 0) {
                this.categories.remove(category);
            }
            return (Serializable)removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getCurrentState() {
        HashMap<String, HashMap> retval = new HashMap<String, HashMap>();
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            for (Map.Entry entry : this.categories.entrySet()) {
                String catName = (String)entry.getKey();
                HashMap value = (HashMap)entry.getValue();
                HashMap newVal = value != null ? (HashMap)value.clone() : null;
                retval.put(catName, newVal);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentState(Serializable newState) {
        HashMap hashMap = this.categories;
        synchronized (hashMap) {
            this.categories.clear();
            this.categories.putAll((HashMap)newState);
            if (this.keyListeners.size() > 0) {
                this.cleanupKeyListeners();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerListener(String category, Object subscriber) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList<Object> listeners = (ArrayList<Object>)this.keyListeners.get(category);
            if (listeners == null) {
                listeners = new ArrayList<Object>();
                this.keyListeners.put(category, listeners);
            }
            listeners.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListener(String category, Object subscriber) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            listeners.remove(subscriber);
            if (listeners.size() == 0) {
                this.keyListeners.remove(category);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyKeyListeners(String category, Serializable key, Serializable value, boolean locallyModified) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            String strKey = key.toString();
            for (int i = 0; i < listeners.size(); ++i) {
                Object dslistener;
                Object listener = listeners.get(i);
                if (listener instanceof DistributedState.DSListener) {
                    dslistener = (DistributedState.DSListener)listener;
                    dslistener.valueHasChanged(category, strKey, value, locallyModified);
                    continue;
                }
                dslistener = (DistributedState.DSListenerEx)listener;
                dslistener.valueHasChanged(category, key, value, locallyModified);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyKeyListenersOfRemove(String category, Serializable key, Serializable oldContent, boolean locallyModified) {
        HashMap hashMap = this.keyListeners;
        synchronized (hashMap) {
            ArrayList listeners = (ArrayList)this.keyListeners.get(category);
            if (listeners == null) {
                return;
            }
            String strKey = key.toString();
            for (int i = 0; i < listeners.size(); ++i) {
                Object dslistener;
                Object listener = listeners.get(i);
                if (listener instanceof DistributedState.DSListener) {
                    dslistener = (DistributedState.DSListener)listener;
                    dslistener.keyHasBeenRemoved(category, strKey, oldContent, locallyModified);
                    continue;
                }
                dslistener = (DistributedState.DSListenerEx)listener;
                dslistener.keyHasBeenRemoved(category, key, oldContent, locallyModified);
            }
        }
    }

    protected void cleanupKeyListeners() {
    }
}

