/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.cms;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.jboss.portal.common.util.Base64;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.core.model.portal.PortalObjectPath;

public class CMSObjectPath
implements Comparable,
Serializable {
    private static final String[] EMPTY_STRINGS = new String[0];
    public static final CMSObjectPath ROOT_PATH = new CMSObjectPath();
    private final String[] names;
    private final int from;
    private final int to;
    private Integer hashCode;
    private String toStringCanonicalFormat;
    private CMSObjectPath parent;
    public static final Format CANONICAL_FORMAT = new CanonicalFormat();
    public static final Format SAFEST_FORMAT = new SafestFormat();
    public static final PortalObjectPath.Format LEGACY_BASE64_FORMAT = new PortalObjectPath.LegacyFormat(){

        protected String decodeName(String name) {
            try {
                byte[] bytes = Base64.decode((String)name);
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }

        protected String encodeName(String name) {
            try {
                byte[] bytes = name.getBytes("UTF-8");
                name = Base64.encodeBytes((byte[])bytes, (Base64.EncodingOption)Base64.EncodingOption.NOCARRIAGERETURN);
                return name;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
    };

    public CMSObjectPath() {
        this.names = EMPTY_STRINGS;
        this.from = 0;
        this.to = 0;
    }

    public CMSObjectPath(CMSObjectPath that) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)that, (String)"PortalObjectId to be copied");
        this.names = that.names;
        this.hashCode = that.hashCode;
        this.from = that.from;
        this.to = that.to;
    }

    public CMSObjectPath(String[] names) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)names, (String)"composing names");
        this.names = names;
        this.from = 0;
        this.to = names.length;
    }

    private CMSObjectPath(String[] names, int from, int to) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)names, (String)"composing names");
        this.names = names;
        this.from = from;
        this.to = to;
    }

    public CMSObjectPath getParent() {
        if (this.parent == null && this.from < this.to) {
            this.parent = new CMSObjectPath(this.names, this.from, this.to - 1);
        }
        return this.parent;
    }

    public CMSObjectPath getChild(String name) {
        int length = this.to - this.from;
        String[] childNames = new String[length + 1];
        System.arraycopy(this.names, this.from, childNames, 0, length);
        childNames[length] = name;
        return new CMSObjectPath(childNames);
    }

    public CMSObjectPath(String value, Format format) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)format, (String)"Format");
        this.names = format.parse(value);
        this.from = 0;
        this.to = this.names.length;
    }

    public int getLength() {
        return this.to - this.from;
    }

    public String getName(int index) {
        if (index < this.from) {
            throw new IllegalArgumentException();
        }
        if (index >= this.to) {
            throw new IllegalArgumentException();
        }
        return this.names[index - this.from];
    }

    public String getLastComponentName() {
        return this.names[this.names.length - 1];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CMSObjectPath) {
            CMSObjectPath that = (CMSObjectPath)obj;
            String[] thisNames = this.names;
            String[] thatNames = that.names;
            int thisLen = this.to - this.from;
            int thatLen = that.to - that.from;
            if (thisLen != thatLen) {
                return false;
            }
            int thisIdx = this.from;
            int thatIdx = that.from;
            while (thisLen-- > 0) {
                if (thisNames[thisIdx++].equals(thatNames[thatIdx++])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int value = 0;
            for (int i = this.to - 1; i >= this.from; --i) {
                value = value * 41 + this.names[i].hashCode();
            }
            this.hashCode = new Integer(value);
        }
        return this.hashCode;
    }

    public int compareTo(Object o) {
        CMSObjectPath that = (CMSObjectPath)o;
        for (int index = 0; index < this.names.length && index < that.names.length; ++index) {
            String thisName = this.names[index];
            String thatName = that.names[index];
            int order = thisName.compareTo(thatName);
            if (order == 0) continue;
            return order;
        }
        return that.names.length - this.names.length;
    }

    public Iterator names() {
        return Tools.iterator((Object[])this.names, (int)this.from, (int)this.to);
    }

    public String toString() {
        return this.toString(CANONICAL_FORMAT);
    }

    public String toString(Format format) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)format, (String)"Format");
        if (format == CANONICAL_FORMAT) {
            if (this.toStringCanonicalFormat == null) {
                this.toStringCanonicalFormat = CANONICAL_FORMAT.toString(this.names, this.from, this.to);
            }
            return this.toStringCanonicalFormat;
        }
        return format.toString(this.names, this.from, this.to);
    }

    public static CMSObjectPath parse(String value) {
        return new CMSObjectPath(value, CANONICAL_FORMAT);
    }

    public static CMSObjectPath parse(String value, Format format) {
        return new CMSObjectPath(value, format);
    }

    public static final class SafestFormat
    extends Format {
        private final String EQUALS = "_e";
        private final String SLASH = "_s";
        private final String DOT = "_d";
        private final String PLUS = "_p";

        public String[] parse(String value) {
            String uncoded = value.replace("_e", "=");
            uncoded = uncoded.replace("_s", "/");
            uncoded = uncoded.replace("_d", ".");
            uncoded = uncoded.replace("_p", "+");
            return LEGACY_BASE64_FORMAT.parse(uncoded);
        }

        public String toString(String[] names, int from, int to) {
            String encoded = LEGACY_BASE64_FORMAT.toString(names, from, to);
            encoded = encoded.replace("=", "_e");
            encoded = encoded.replace("/", "_s");
            encoded = encoded.replace(".", "_d");
            encoded = encoded.replace("+", "_p");
            return encoded;
        }
    }

    public static final class CanonicalFormat
    extends Format {
        public static final char PATH_SEPARATOR = '/';

        public String[] parse(String value) {
            String name;
            int next;
            ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)value, (String)"value", (String)"Format.parse(value)");
            if (value.charAt(0) != '/') {
                throw new IllegalArgumentException("Not a canonical value " + value);
            }
            if (value.length() == 1) {
                return new String[0];
            }
            int length = 1;
            int previous = 1;
            while ((next = value.indexOf(47, previous)) != -1) {
                if (next > 0 && value.charAt(next - 1) != '\\') {
                    ++length;
                }
                previous = next + 1;
            }
            String[] names = new String[length];
            length = 0;
            previous = 1;
            int next2 = 1;
            while ((next2 = value.indexOf(47, next2)) != -1) {
                if (next2 > 0 && value.charAt(next2 - 1) != '\\') {
                    name = value.substring(previous, next2);
                    name = this.decodeName(name);
                    names[length++] = name;
                    previous = next2 + 1;
                }
                ++next2;
            }
            name = value.substring(previous);
            names[length] = name = this.decodeName(name);
            return names;
        }

        public String toString(String[] names, int from, int to) {
            ParameterValidation.throwIllegalArgExceptionIfNull((Object)names, (String)"name string array");
            if (from == to) {
                return "/";
            }
            StringBuffer tmp = new StringBuffer(names.length * 10);
            for (int i = from; i < to; ++i) {
                String name = names[i];
                if (name == null) {
                    throw new IllegalArgumentException("No null name expected in the name string array");
                }
                name = this.encodeName(name);
                tmp.append('/').append(name);
            }
            return tmp.toString();
        }

        protected String decodeName(String name) {
            return name.replaceAll("\\/", "/");
        }

        protected String encodeName(String name) {
            return name.replaceAll("/", "\\/");
        }
    }

    public static abstract class Format {
        public abstract String[] parse(String var1) throws IllegalArgumentException;

        public abstract String toString(String[] var1, int var2, int var3) throws IllegalArgumentException;

        public final String toString(CMSObjectPath id) throws IllegalArgumentException {
            ParameterValidation.throwIllegalArgExceptionIfNull((Object)id, (String)"cmsPath");
            return this.toString(id.names, id.from, id.to);
        }
    }
}

