/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.error;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Debug {
    public static String toString(Object anObject) {
        StringBuffer result = new StringBuffer();
        result.append(anObject.getClass().getName());
        result.append('@');
        result.append(Integer.toHexString(System.identityHashCode(anObject)));
        return result.toString();
    }

    public static String getClassName(Object anObject) {
        if (anObject == null) {
            return null;
        }
        return Debug.getSimpleName(anObject.getClass());
    }

    public static String getAbsoluteClassName(Object anObject) {
        if (anObject == null) {
            return null;
        }
        return anObject.getClass().getName();
    }

    public static String getSimpleName(Class<?> aClass) {
        String className = null;
        className = aClass.getSimpleName();
        return className;
    }

    public static String stackTraceToString(Throwable aCause) {
        String result = "";
        if (aCause != null) {
            StringWriter writer = new StringWriter();
            aCause.printStackTrace(new PrintWriter(writer));
            result = writer.toString();
        }
        return result;
    }

    public static void printStackTrace(int aDepth) {
        Debug.printStackTrace(aDepth, System.err, 3);
    }

    public static void printStackTrace(int aDepth, PrintStream aPrintStream) {
        Debug.printStackTrace(aDepth, aPrintStream, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStackTrace(int aDepth, PrintStream aPrintStream, int skipLevel) {
        Exception aCause = new Exception();
        PrintStream printStream = aPrintStream;
        synchronized (printStream) {
            StackTraceElement[] trace = aCause.getStackTrace();
            if (trace != null) {
                int length = trace.length;
                if (length > skipLevel) {
                    aPrintStream.println("" + trace[skipLevel - 1]);
                    for (int i = skipLevel; i < trace.length && i < aDepth + skipLevel; ++i) {
                        aPrintStream.println("\tat " + trace[i]);
                    }
                }
                aPrintStream.println();
            }
        }
    }

    public static String throwableToString(Throwable aCause) {
        StringBuffer buff = new StringBuffer();
        buff.append(Debug.allMessagesToString(aCause));
        buff.append("\n\n---------------------\n\n");
        buff.append(Debug.stackTraceToString(aCause));
        return buff.toString();
    }

    public static String[] getAllMessages(Throwable aCause) {
        LinkedList<String> messages = new LinkedList<String>();
        for (Throwable subCause = aCause; subCause != null; subCause = subCause.getCause()) {
            if (subCause.getMessage() != null && !subCause.getMessage().equals("")) {
                messages.add(subCause.getMessage());
                continue;
            }
            messages.add(subCause.getClass().getName());
        }
        return messages.toArray(new String[0]);
    }

    public static String allMessagesToString(Throwable aCause) {
        StringBuffer buff = new StringBuffer();
        String[] messages = Debug.getAllMessages(aCause);
        if (messages.length > 0) {
            buff.append(messages[0]);
            for (int i = 1; i < messages.length; ++i) {
                buff.append("\nCause : ").append(messages[i]);
            }
        }
        return buff.toString();
    }

    public static void printArray(Object[] anArray) {
        Debug.printArray(anArray, 0);
    }

    public static void printCollec(Collection<?> aCollec) {
        Debug.printCollec(aCollec, 0);
    }

    public static void print(Object anObj) {
        Debug.print(anObj, 0);
    }

    private static void printArray(Object[] anArray, int anIndentLevel) {
        if (anArray == null) {
            System.out.println("null");
        } else {
            Class<?> itemsType = anArray.getClass().getComponentType();
            System.out.print(Debug.getSimpleName(itemsType) + "[] = {");
            if (anArray.length > 0) {
                System.out.println();
                for (int i = 0; i < anArray.length; ++i) {
                    Debug.print(anArray[i], anIndentLevel + 1);
                }
                Debug.indent(anIndentLevel);
            }
            System.out.println("}");
        }
    }

    private static void printCollec(Collection<?> aCollec, int anIndentLevel) {
        if (aCollec == null) {
            System.out.println("null");
        } else {
            System.out.print(Debug.getClassName(aCollec) + " = {");
            if (!aCollec.isEmpty()) {
                System.out.println();
                Iterator<?> it = aCollec.iterator();
                while (it.hasNext()) {
                    Debug.print(it.next(), anIndentLevel + 1);
                }
                Debug.indent(anIndentLevel);
            }
            System.out.println("}");
        }
    }

    private static void print(Object anObj, int anIndentLevel) {
        Debug.indent(anIndentLevel);
        if (anObj == null) {
            System.out.println("null");
        } else if (anObj instanceof String) {
            System.out.println("\"" + anObj + "\"");
        } else if (anObj instanceof Object[]) {
            Debug.printArray((Object[])anObj, anIndentLevel);
        } else if (anObj instanceof Collection) {
            Debug.printCollec((Collection)anObj, anIndentLevel);
        } else {
            System.out.println(anObj.toString());
        }
    }

    private static void indent(int aLevel) {
        for (int i = 0; i < aLevel; ++i) {
            System.out.print("  ");
        }
    }
}

