/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.registration.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.registration.Consumer;
import org.jboss.portal.registration.ConsumerCapabilities;
import org.jboss.portal.registration.ConsumerGroup;
import org.jboss.portal.registration.Registration;
import org.jboss.portal.registration.RegistrationException;
import org.jboss.portal.registration.RegistrationStatus;
import org.jboss.portal.registration.RegistrationUtils;
import org.jboss.portal.registration.impl.ConsumerCapabilitiesImpl;

public class ConsumerImpl
implements Consumer {
    private String name;
    private String identity;
    private String consumerAgent;
    private Set registrations;
    private RegistrationStatus status;
    private ConsumerGroup group;
    private ConsumerCapabilities capabilities;

    private ConsumerImpl() {
        this.init();
    }

    ConsumerImpl(String identity, String name) {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"name", (String)"Consumer");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"identity", (String)"Consumer");
        this.name = name;
        this.identity = identity;
        this.init();
    }

    private void init() {
        this.registrations = new HashSet(7);
        this.status = RegistrationStatus.PENDING;
        this.capabilities = new ConsumerCapabilitiesImpl();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerImpl consumer = (ConsumerImpl)o;
        return this.identity.equals(consumer.identity);
    }

    public int hashCode() {
        return this.identity.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.identity;
    }

    public String getConsumerAgent() {
        return this.consumerAgent;
    }

    public void setConsumerAgent(String consumerAgent) throws IllegalArgumentException, IllegalStateException {
        if (consumerAgent != null && !consumerAgent.equals(this.consumerAgent)) {
            RegistrationUtils.validateConsumerAgent(consumerAgent);
            this.consumerAgent = consumerAgent;
        }
    }

    public ConsumerCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(ConsumerCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public RegistrationStatus getStatus() {
        return this.status;
    }

    public void setStatus(RegistrationStatus status) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)status, (String)"RegistrationStatus");
        this.status = status;
    }

    public Collection getRegistrations() throws RegistrationException {
        return Collections.unmodifiableSet(this.registrations);
    }

    public ConsumerGroup getGroup() {
        return this.group;
    }

    void addRegistration(Registration registration) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registration, (String)"Registration");
        this.registrations.add(registration);
    }

    void removeRegistration(Registration registration) throws RegistrationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)registration, (String)"Registration");
        this.registrations.remove(registration);
        if (this.registrations.isEmpty()) {
            this.setStatus(RegistrationStatus.PENDING);
        }
    }

    public void setGroup(ConsumerGroup group) throws RegistrationException {
        if (this.group != null) {
            if (this.group.equals(group)) {
                return;
            }
            if (this.group.contains(this)) {
                this.group.removeConsumer(this);
            }
        }
        this.group = group;
        if (group != null && !this.group.contains(this)) {
            group.addConsumer(this);
        }
    }
}

