/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.services.dao;

import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.IDAO;
import java.util.Date;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.locator.Locator;

public final class CommentDAO
implements IDAO<JSONObject, CommentDTO> {
    private static CommentDAO instance;
    private final IDirectoryServiceLocator directoryServiceLocator = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");

    private CommentDAO() {
    }

    public static CommentDAO getInstance() {
        if (instance == null) {
            instance = new CommentDAO();
        }
        return instance;
    }

    @Override
    public CommentDTO toDTO(JSONObject jsonObject) {
        CommentDTO dto = new CommentDTO();
        dto.setId(jsonObject.getString("id"));
        dto.setPath(jsonObject.getString("path"));
        String author = jsonObject.getString("author");
        dto.setAuthor(author);
        IDirectoryService directoryService = this.directoryServiceLocator.getDirectoryService();
        if (directoryService != null) {
            dto.setPerson(directoryService.getPerson(author));
        }
        JSONObject jsonDate = jsonObject.getJSONObject("creationDate");
        dto.setCreationDate(new Date(jsonDate.getLong("timeInMillis")));
        String content = jsonObject.getString("content");
        dto.setContent(content);
        dto.setDeletable(jsonObject.getBoolean("canDelete"));
        JSONArray jsonChildren = jsonObject.getJSONArray("children");
        for (int i = 0; i < jsonChildren.size(); ++i) {
            JSONObject jsonChild = jsonChildren.getJSONObject(i);
            CommentDTO childDTO = this.toDTO(jsonChild);
            dto.getChildren().add(childDTO);
        }
        return dto;
    }
}

