/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scanner;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.jboss.net.protocol.URLLister;

public class DeploymentFilter
implements FileFilter,
URLLister.URLFilter {
    private static final Comparator reverseComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int idx1 = ((String)o1).length();
            int idx2 = ((String)o2).length();
            int comp = 0;
            while (comp == 0 && idx1 > 0 && idx2 > 0) {
                comp = ((String)o1).charAt(--idx1) - ((String)o2).charAt(--idx2);
            }
            return comp == 0 ? idx1 - idx2 : comp;
        }
    };
    private static final String[] DEFAULT_PREFIXES = new String[]{"#", "%", ",", ".", "_$"};
    private static final String[] DEFAULT_SUFFIXES = new String[]{"#", "$", "%", "~", ",v", ".BAK", ".bak", ".old", ".orig", ".tmp", ".rej", ".sh"};
    private static final String[] DEFAULT_MATCHES = new String[]{".make.state", ".nse_depinfo", "CVS", "CVS.admin", "RCS", "RCSLOG", "SCCS", "TAGS", "core", "tags"};
    private ArrayList suffixes;
    private ArrayList prefixes;
    private ArrayList matches;

    public DeploymentFilter() {
        this(DEFAULT_MATCHES, DEFAULT_PREFIXES, DEFAULT_SUFFIXES);
    }

    public DeploymentFilter(String[] matches, String[] prefixes, String[] suffixes) {
        if (matches == null) {
            matches = DEFAULT_MATCHES;
        }
        Arrays.sort(matches);
        this.matches = new ArrayList<String>(Arrays.asList(matches));
        if (prefixes == null) {
            prefixes = DEFAULT_PREFIXES;
        }
        Arrays.sort(prefixes);
        this.prefixes = new ArrayList<String>(Arrays.asList(prefixes));
        if (suffixes == null) {
            suffixes = DEFAULT_SUFFIXES;
        }
        Arrays.sort(suffixes, reverseComparator);
        this.suffixes = new ArrayList<String>(Arrays.asList(suffixes));
    }

    public void addPrefix(String prefix) {
        this.prefixes.add(prefix);
        Collections.sort(this.prefixes);
    }

    public void addPrefixes(String[] prefixes) {
        this.prefixes.add(Arrays.asList(prefixes));
        Collections.sort(this.prefixes);
    }

    public void delPrefix(String prefix) {
        this.prefixes.remove(prefix);
    }

    public void delPrefixes(String[] prefixes) {
        this.prefixes.removeAll(Arrays.asList(prefixes));
        Collections.sort(this.prefixes);
    }

    public void addSuffix(String suffix) {
        this.suffixes.add(suffix);
        Collections.sort(this.suffixes, reverseComparator);
    }

    public void addSuffixes(String[] suffixes) {
        this.suffixes.add(Arrays.asList(suffixes));
        Collections.sort(this.suffixes, reverseComparator);
    }

    public void delSuffix(String suffix) {
        this.suffixes.remove(suffix);
    }

    public void delSuffixes(String[] suffixes) {
        this.suffixes.removeAll(Arrays.asList(suffixes));
        Collections.sort(this.suffixes, reverseComparator);
    }

    public String[] getSuffixes() {
        String[] tmp = new String[this.suffixes.size()];
        this.suffixes.toArray(tmp);
        return tmp;
    }

    public void setSuffixes(String[] suffixes) {
        Arrays.sort(suffixes, reverseComparator);
        this.suffixes.clear();
        this.suffixes.addAll(Arrays.asList(suffixes));
    }

    public String[] getPrefixes() {
        String[] tmp = new String[this.prefixes.size()];
        this.prefixes.toArray(tmp);
        return tmp;
    }

    public void setPrefixes(String[] prefixes) {
        Arrays.sort(prefixes);
        this.prefixes.clear();
        this.prefixes.addAll(Arrays.asList(prefixes));
    }

    public String[] getMatches() {
        String[] tmp = new String[this.matches.size()];
        this.matches.toArray(tmp);
        return tmp;
    }

    public void setMatches(String[] matches) {
        Arrays.sort(matches);
        this.matches.clear();
        this.matches.addAll(Arrays.asList(matches));
    }

    public boolean accept(File file) {
        return this.accept(file.getName());
    }

    public boolean accept(URL baseURL, String memberName) {
        return this.accept(memberName);
    }

    private boolean accept(String name) {
        String suffix;
        int firstLessIndex;
        String prefix;
        int index = Collections.binarySearch(this.matches, name);
        if (index >= 0) {
            return false;
        }
        index = Collections.binarySearch(this.prefixes, name);
        if (index >= 0) {
            return false;
        }
        if (index < -1 && name.startsWith(prefix = (String)this.prefixes.get(firstLessIndex = -2 - index))) {
            return false;
        }
        index = Collections.binarySearch(this.suffixes, name, reverseComparator);
        if (index >= 0) {
            return false;
        }
        return index >= -1 || !name.endsWith(suffix = (String)this.suffixes.get(firstLessIndex = -2 - index));
    }
}

