/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.StateManager;
import javax.faces.application.StateManagerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.faces.BridgeUtil;
import org.jboss.portletbridge.context.PortletBridgeContext;

public class PortletStateManager
extends StateManagerWrapper {
    private StateManager parent;
    static final Pattern PATTERN = Pattern.compile(".*<input.*(?:\\svalue=[\"'](.*)[\"']\\s).*name=[\"']javax.faces.ViewState[\"'].*>");
    static final Pattern PATTERN2 = Pattern.compile(".*<input .*name=[\"']javax.faces.ViewState[\"'].*(?:\\svalue=[\"'](.*)[\"']\\s).*>");

    public PortletStateManager(StateManager parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeState(FacesContext context, Object state) throws IOException {
        if (BridgeUtil.isPortletRequest()) {
            ResponseWriter originalWriter = context.getResponseWriter();
            StringWriter buff = new StringWriter(128);
            try {
                ResponseWriter stateResponseWriter = originalWriter.cloneWithWriter((Writer)buff);
                context.setResponseWriter(stateResponseWriter);
                super.writeState(context, state);
                stateResponseWriter.flush();
                String stateString = buff.toString();
                originalWriter.write(stateString);
                String stateValue = this.getStateValue(stateString);
                PortletBridgeContext bridgeContext = (PortletBridgeContext)context.getExternalContext().getRequestMap().get(PortletBridgeContext.REQUEST_PARAMETER_NAME);
                if (null == bridgeContext) return;
                Map<String, String[]> requestParameters = bridgeContext.getWindowState().getRequestParameters();
                if (null != stateValue) {
                    requestParameters.put("javax.faces.ViewState", new String[]{stateValue});
                    return;
                }
                requestParameters.remove("javax.faces.ViewState");
                return;
            }
            finally {
                context.setResponseWriter(originalWriter);
            }
        } else {
            super.writeState(context, state);
        }
    }

    private String getStateValue(String input) {
        Matcher matcher = PATTERN.matcher(input);
        if (!matcher.matches() && !(matcher = PATTERN2.matcher(input)).matches()) {
            return null;
        }
        return matcher.group(1);
    }

    protected StateManager getWrapped() {
        return this.parent;
    }
}

