/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.jboss.portal.server.deployment.CannotCreatePortletWebAppException;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.PortalWebTomcat4App;
import org.jboss.portal.web.command.CommandServlet;
import org.jboss.web.WebApplication;
import org.xml.sax.EntityResolver;

public class PortalWebTomcat6App
extends PortalWebApp {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Object standardContext;
    private final WebApplication webApp;

    public PortalWebTomcat6App(WebApplication webApp, MBeanServer server, EntityResolver jbossAppEntityResolver) throws CannotCreatePortletWebAppException {
        try {
            ObjectName name = (ObjectName)webApp.getAppData();
            this.webApp = webApp;
            this.standardContext = server.getAttribute(name, "managedResource");
            String contextPath = PortalWebTomcat4App.getContextPath(this.standardContext);
            ServletContext servletContext = PortalWebTomcat4App.getServletContext(this.standardContext);
            ClassLoader loader = this.getClassLoader(server, name);
            URL url = webApp.getURL();
            this.init(servletContext, url, loader, contextPath, jbossAppEntityResolver);
        }
        catch (Exception e) {
            CannotCreatePortletWebAppException ex = e instanceof CannotCreatePortletWebAppException ? (CannotCreatePortletWebAppException)e : new CannotCreatePortletWebAppException(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instrument() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> containerItf = cl.loadClass("org.apache.catalina.Container");
        Method findChildMethod = containerItf.getMethod("findChild", String.class);
        Object commandServlet = findChildMethod.invoke(this.standardContext, "CommandServlet");
        if (commandServlet == null) {
            this.setRunAsListenerAssociation(this.webApp.getMetaData());
            try {
                this.addCommandServlet(cl);
            }
            finally {
                this.setRunAsListenerAssociation(null);
            }
        }
    }

    private void setRunAsListenerAssociation(Object o) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.jboss.web.tomcat.security.RunAsListener");
            this.log.debug((Object)"RunAsListener detected");
            Field field = clazz.getDeclaredField("metaDataLocal");
            ThreadLocal threadLocal = (ThreadLocal)field.get(null);
            threadLocal.set(o);
        }
        catch (ClassNotFoundException e) {
            this.log.debug((Object)"RunAsListener not detected");
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)"Cannot set the RunAsListener threadlocal because of a security manager", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Unexpected exception");
        }
    }

    private void addCommandServlet(ClassLoader cl) throws Exception {
        Class<?> containerItf = cl.loadClass("org.apache.catalina.Container");
        Class<?> standardContextClass = cl.loadClass("org.apache.catalina.core.StandardContext");
        Class<?> containerBaseClass = cl.loadClass("org.apache.catalina.core.ContainerBase");
        Class<?> contextItf = cl.loadClass("org.apache.catalina.Context");
        Method createWrapperMethod = standardContextClass.getMethod("createWrapper", EMPTY_CLASS_ARRAY);
        Object wrapper = createWrapperMethod.invoke(this.standardContext, EMPTY_OBJECT_ARRAY);
        Class<?> wrapperClass = wrapper.getClass();
        Object[] wrapperArray = (Object[])Array.newInstance(containerItf, 1);
        wrapperArray[0] = wrapper;
        Method setServletNameMethod = wrapperClass.getMethod("setServletName", String.class);
        setServletNameMethod.invoke(wrapper, "CommandServlet");
        Method setServletClassMethod = wrapperClass.getMethod("setServletClass", String.class);
        setServletClassMethod.invoke(wrapper, CommandServlet.class.getName());
        Method setLoadOnStartupMethod = wrapperClass.getMethod("setLoadOnStartup", Integer.TYPE);
        setLoadOnStartupMethod.invoke(wrapper, new Integer(0));
        Method addChildMethod = containerBaseClass.getMethod("addChild", containerItf);
        addChildMethod.invoke(this.standardContext, wrapper);
        Method addServletMapping = contextItf.getMethod("addServletMapping", String.class, String.class);
        addServletMapping.invoke(this.standardContext, "/jbossportlet", "CommandServlet");
        Method loadOnStartupMethod = standardContextClass.getMethod("loadOnStartup", wrapperArray.getClass());
        loadOnStartupMethod.invoke(this.standardContext, new Object[]{wrapperArray});
    }

    private ClassLoader getClassLoader(MBeanServer server, ObjectName name) throws Exception {
        Object loader = server.getAttribute(name, "loader");
        Method getClassLoaderMethod = loader.getClass().getMethod("getClassLoader", new Class[0]);
        return (ClassLoader)getClassLoaderMethod.invoke(loader, new Object[0]);
    }
}

