/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.reflection.ReflectionManager;
import org.hibernate.reflection.XClass;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.AddWork;
import org.hibernate.search.backend.DeleteWork;
import org.hibernate.search.backend.UpdateWork;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.impl.BatchLuceneWorkQueue;
import org.hibernate.search.backend.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderFactory;
import org.hibernate.search.util.WeakIdentityHashMap;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextIndexEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
Initializable {
    protected ReflectionManager reflectionManager;
    protected WeakIdentityHashMap queuePerTransaction;
    private Map<Class, DocumentBuilder<Object>> documentBuilders = new HashMap<Class, DocumentBuilder<Object>>();
    private Map<DirectoryProvider, ReentrantLock> lockableDirectoryProviders = new HashMap<DirectoryProvider, ReentrantLock>();
    private boolean initialized;
    private static final Log log = LogFactory.getLog(FullTextIndexEventListener.class);

    @Deprecated
    public Map<Class, DocumentBuilder<Object>> getDocumentBuilders() {
        return this.documentBuilders;
    }

    public void initialize(Configuration cfg) {
        Analyzer analyzer;
        Class analyzerClass;
        if (this.initialized) {
            return;
        }
        this.reflectionManager = ((AnnotationConfiguration)cfg).createExtendedMappings().getReflectionManager();
        this.queuePerTransaction = new WeakIdentityHashMap();
        String analyzerClassName = cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ReflectHelper.classForName((String)analyzerClassName);
            }
            catch (Exception e) {
                throw new HibernateException("Lucene analyzer class '" + analyzerClassName + "' defined in property '" + "hibernate.search.analyzer" + "' could not be found.", (Throwable)e);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        try {
            analyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new HibernateException("Lucene analyzer does not implement " + Analyzer.class.getName() + ": " + analyzerClassName);
        }
        catch (Exception e) {
            throw new HibernateException("Failed to instantiate lucene analyzer with type " + analyzerClassName);
        }
        Iterator iter = cfg.getClassMappings();
        DirectoryProviderFactory factory = new DirectoryProviderFactory();
        while (iter.hasNext()) {
            XClass mappedXClass;
            PersistentClass clazz = (PersistentClass)iter.next();
            Class mappedClass = clazz.getMappedClass();
            if (mappedClass == null || (mappedXClass = this.reflectionManager.toXClass(mappedClass)) == null || !mappedXClass.isAnnotationPresent(Indexed.class)) continue;
            DirectoryProvider<?> provider = factory.createDirectoryProvider(mappedXClass, cfg);
            if (!this.lockableDirectoryProviders.containsKey(provider)) {
                this.lockableDirectoryProviders.put(provider, new ReentrantLock());
            }
            DocumentBuilder documentBuilder = new DocumentBuilder(mappedXClass, analyzer, provider, this.reflectionManager);
            this.documentBuilders.put(mappedClass, documentBuilder);
        }
        Set<Class> indexedClasses = this.documentBuilders.keySet();
        for (DocumentBuilder<Object> builder : this.documentBuilders.values()) {
            builder.postInitialize(indexedClasses);
        }
        this.initialized = true;
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (this.documentBuilders.containsKey(event.getEntity().getClass())) {
            DeleteWork work = new DeleteWork(event.getId(), event.getEntity().getClass());
            this.processWork(work, (AbstractEvent)event);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        Object entity = event.getEntity();
        DocumentBuilder<Object> builder = this.documentBuilders.get(entity.getClass());
        if (builder != null) {
            Serializable id = event.getId();
            Document doc = builder.getDocument(entity, id);
            AddWork work = new AddWork(id, entity.getClass(), doc);
            this.processWork(work, (AbstractEvent)event);
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity = event.getEntity();
        DocumentBuilder<Object> builder = this.documentBuilders.get(entity.getClass());
        if (builder != null) {
            Serializable id = event.getId();
            Document doc = builder.getDocument(entity, id);
            UpdateWork work = new UpdateWork(id, entity.getClass(), doc);
            this.processWork(work, (AbstractEvent)event);
        }
    }

    private void processWork(Work work, AbstractEvent event) {
        if (event.getSession().isTransactionInProgress()) {
            Transaction transaction = event.getSession().getTransaction();
            PostTransactionWorkQueueSynchronization sync = (PostTransactionWorkQueueSynchronization)this.queuePerTransaction.get(transaction);
            if (sync == null || sync.isConsumed()) {
                BatchLuceneWorkQueue workQueue = new BatchLuceneWorkQueue(this.documentBuilders, this.lockableDirectoryProviders);
                sync = new PostTransactionWorkQueueSynchronization(workQueue, this.queuePerTransaction);
                transaction.registerSynchronization((Synchronization)sync);
                this.queuePerTransaction.put(transaction, sync);
            }
            sync.add(work);
        } else {
            BatchLuceneWorkQueue workQueue = new BatchLuceneWorkQueue(this.documentBuilders, this.lockableDirectoryProviders);
            PostTransactionWorkQueueSynchronization sync = new PostTransactionWorkQueueSynchronization(workQueue);
            sync.add(work);
            sync.afterCompletion(3);
        }
    }

    public Map<DirectoryProvider, ReentrantLock> getLockableDirectoryProviders() {
        return this.lockableDirectoryProviders;
    }
}

