/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeScheduler
extends Timer {
    private int size = 0;
    protected static final Log log = LogFactory.getLog((Class)TimeScheduler.class);

    public TimeScheduler() {
        super(true);
    }

    public TimeScheduler(boolean isDaemon) {
        super(isDaemon);
    }

    public String dumpTaskQueue() {
        return this.toString();
    }

    public void add(Task task, boolean relative) {
        TaskWrapper wrapper = new TaskWrapper(task);
        this.schedule((TimerTask)wrapper, task.nextInterval());
    }

    public void add(Task t) {
        this.add(t, true);
    }

    public void schedule(TimerTask task, long delay) {
        super.schedule(task, delay);
        ++this.size;
    }

    public void schedule(TimerTask task, long delay, long period) {
        super.schedule(task, delay, period);
        ++this.size;
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        super.schedule(task, firstTime, period);
        ++this.size;
    }

    public void schedule(TimerTask task, Date time) {
        super.schedule(task, time);
        ++this.size;
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        super.scheduleAtFixedRate(task, delay, period);
        ++this.size;
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        super.scheduleAtFixedRate(task, firstTime, period);
        ++this.size;
    }

    public void cancel() {
        super.cancel();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void start() {
    }

    public void stop() throws InterruptedException {
    }

    private class TaskWrapper
    extends TimerTask {
        private final Task delegate;

        public TaskWrapper(Task delegate) {
            this.delegate = delegate;
        }

        public void run() {
            block4: {
                if (this.delegate.cancelled()) {
                    this.cancel();
                    return;
                }
                try {
                    this.delegate.run();
                }
                catch (Throwable t) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("exception executing task " + this.delegate), t);
                }
            }
            TimeScheduler.this.size = Math.max(TimeScheduler.this.size - 1, 0);
            if (!this.delegate.cancelled()) {
                long next_interval = this.delegate.nextInterval();
                TaskWrapper new_task = new TaskWrapper(this.delegate);
                TimeScheduler.this.schedule((TimerTask)new_task, next_interval);
            }
        }

        public boolean cancel() {
            TimeScheduler.this.size = Math.max(0, TimeScheduler.this.size - 1);
            return super.cancel();
        }
    }

    public static interface CancellableTask
    extends Task {
        public void cancel();
    }

    public static interface Task {
        public boolean cancelled();

        public long nextInterval();

        public void run();
    }
}

