/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.identity.sso.cas;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.jboss.portal.identity.helper.IdentityTools;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.login.IUserDatasModuleRepository;
import org.osivia.portal.api.login.UserDatasModuleMetadatas;

public class CASAuthenticationValve
extends ValveBase {
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    private static final String UTF_8 = "UTF-8";
    public static final String VIRTUAL_HOST_REQUEST_HEADER = "osivia-virtual-host";
    private static final String SEP = ":";
    private static final Logger log = Logger.getLogger(CASAuthenticationValve.class);
    public static final String LOGIN_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.loginUrl";
    public static final String VALIDATE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.validateUrl";
    public static final String SERVICE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serviceUrl";
    public static final String SERVERNAME_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serverName";
    public static final String RENEW_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.renew";
    public static final String AUTHORIZED_PROXY_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.authorizedProxy";
    public static final String PROXY_CALLBACK_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.proxyCallbackUrl";
    public static final String WRAP_REQUESTS_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.wrapRequest";
    public static final String GATEWAY_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.gateway";
    public static final String CAS_FILTER_USER = "edu.yale.its.tp.cas.client.filter.user";
    public static final String CAS_FILTER_RECEIPT = "edu.yale.its.tp.cas.client.filter.receipt";
    public static final String CONST_CAS_ASSERTION = "_const_cas_assertion_";
    private String casLogin;
    private String casLogout;
    private String casValidate;
    private String casServiceUrl;
    private String casServerName;
    private String casProxyCallbackUrl;
    private String casServerUrlPrefix = null;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private Set urlPatterns;
    private String authType = null;
    private String fileEncoding = System.getProperty("file.encoding");
    private IUserDatasModuleRepository userModuleRepo = (IUserDatasModuleRepository)Locator.findMBean(IUserDatasModuleRepository.class, (String)"osivia:service=Interceptor,type=Server,name=ServerLogin");
    private TicketValidator ticketValidator;

    public String getCasServerUrlPrefix() {
        return this.casServerUrlPrefix;
    }

    public void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    public String getCasLogin() {
        return this.casLogin;
    }

    public void setCasLogin(String casLogin) {
        this.casLogin = casLogin;
    }

    public String getCasLogout() {
        return this.casLogout;
    }

    public void setCasLogout(String casLogout) {
        this.casLogout = casLogout;
    }

    public String getCasServerName() {
        return this.casServerName;
    }

    public void setCasServerName(String casServerName) {
        this.casServerName = casServerName;
    }

    public String getCasValidate() {
        return this.casValidate;
    }

    public void setCasValidate(String casValidate) {
        this.casValidate = casValidate;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getCasServiceUrl() {
        return this.casServiceUrl;
    }

    public void setCasServiceUrl(String casServiceUrl) {
        this.casServiceUrl = casServiceUrl;
    }

    public String getCasProxyCallbackUrl() {
        return this.casProxyCallbackUrl;
    }

    public void setCasProxyCallbackUrl(String casProxyCallbackUrl) {
        this.casProxyCallbackUrl = casProxyCallbackUrl;
    }

    public final boolean redirectToCAS(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        Assertion assertion;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession(false);
        Assertion assertion2 = assertion = session != null ? (Assertion)session.getAttribute(CONST_CAS_ASSERTION) : null;
        if (assertion != null) {
            return false;
        }
        String serviceUrl = this.constructServiceUrl(request, response);
        String ticket = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.getArtifactParameterName());
        if (CommonUtils.isNotBlank((String)ticket)) {
            return false;
        }
        log.debug((Object)"no ticket and no assertion found");
        String modifiedServiceUrl = serviceUrl;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed service url: " + modifiedServiceUrl));
        }
        String urlToRedirectTo = CommonUtils.constructRedirectUrl((String)this.getCasLogin(), (String)this.getServiceParameterName(), (String)modifiedServiceUrl, (boolean)false, (boolean)false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("redirecting to \"" + urlToRedirectTo + "\""));
        }
        response.sendRedirect(urlToRedirectTo);
        return true;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String requestURI;
        Request httpRequest = request;
        HttpSession session = httpRequest.getSession();
        request.setAttribute("ssoEnabled", (Object)"true");
        if (this.fileEncoding != null) {
            request.setCharacterEncoding(this.fileEncoding);
        }
        if (this.isSecuredURI(requestURI = request.getRequestURI()) && this.redirectToCAS((ServletRequest)request, (ServletResponse)response)) {
            return;
        }
        String ticket = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.getArtifactParameterName());
        if (CommonUtils.isNotBlank((String)ticket) && session.getAttribute(CONST_CAS_ASSERTION) == null) {
            try {
                log.info((Object)"avant validation cas");
                Assertion assertion = this.getTicketValidator().validate(ticket, this.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response));
                StringBuffer sb = new StringBuffer();
                sb.append("principal:" + assertion.getPrincipal() + "\n");
                Set attributes = assertion.getPrincipal().getAttributes().keySet();
                for (String attr : attributes) {
                    sb.append(attr + "=" + assertion.getPrincipal().getAttributes().get(attr) + "\n");
                }
                log.info((Object)sb.toString());
                session.setAttribute(CONST_CAS_ASSERTION, (Object)assertion);
                String user = assertion.getPrincipal().getName();
                request.setAttribute("ssoSuccess", (Object)new Boolean(true));
                Principal principal = ((Context)this.container).getRealm().authenticate(user, (String)null);
                if (principal != null) {
                    List<String> feederNames = Arrays.asList("CARTOUNFEEDER", "SUPPORTFEEDER");
                    httpRequest.setAttribute("osivia.valve.feeder", feederNames);
                    UserDatasModuleMetadatas feeder = this.userModuleRepo.getModule("CARTOUNFEEDER");
                    if (feeder == null) {
                        log.info((Object)"CARTOUNFEEDER is null, trying SUPPORTFEEDER");
                        feeder = this.userModuleRepo.getModule("SUPPORTFEEDER");
                    }
                    if (feeder != null) {
                        log.info((Object)("feeder: " + feeder.getName() + ", user: " + user));
                        feeder.getModule().computeLoggedUser((HttpServletRequest)httpRequest);
                    } else {
                        log.info((Object)"SUPPORTFEEDER is null");
                    }
                    this.register(request, response, principal, this.authType, user, null);
                }
            }
            catch (TicketValidationException e) {
                response.setStatus(403);
                log.warn((Object)e, (Throwable)e);
                return;
            }
            catch (Exception e) {
                response.setStatus(403);
                log.warn((Object)e, (Throwable)e);
                return;
            }
        }
        this.getNext().invoke(request, response);
    }

    private void register(Request request, Response response, Principal principal, String authType, String username, String password) {
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
    }

    private boolean isSecuredURI(String uri) {
        Set patterns = this.getSecuredUrlPatterns();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking if requested uri '" + uri + "' matches secured url patterns: " + patterns));
        }
        for (String pattern : patterns) {
            if (uri.indexOf(pattern) == -1) continue;
            return true;
        }
        return false;
    }

    public Set getSecuredUrlPatterns() {
        if (this.urlPatterns == null) {
            this.urlPatterns = IdentityTools.findSecuredURLs((Context)((Context)this.container));
            HashSet<String> urls = new HashSet<String>();
            for (String pattern : this.urlPatterns) {
                urls.add(pattern.replaceAll("\\*", ""));
            }
            this.urlPatterns = urls;
        }
        return this.urlPatterns;
    }

    protected TicketValidator getTicketValidator() {
        if (this.ticketValidator == null) {
            Saml11TicketValidator validator = new Saml11TicketValidator(this.getCasServerUrlPrefix());
            validator.setTolerance(Long.parseLong("360000"));
            validator.setRenew(false);
            validator.setHostnameVerifier(null);
            validator.setEncoding(null);
            this.ticketValidator = validator;
        }
        return this.ticketValidator;
    }

    public final void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    protected final String constructServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        return CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)this.getService(), (String)this.getCasServerName(), (String)this.getArtifactParameterName(), (boolean)true);
    }

    private String getService() {
        return null;
    }

    private String getArtifactParameterName() {
        return "SAMLart";
    }

    private String getServiceParameterName() {
        return "TARGET";
    }
}

