/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hibernate.jdbc.ColumnNameCache;

public class ResultSetWrapper
implements ResultSet {
    private ResultSet rs;
    private ColumnNameCache columnNameCache;

    public ResultSetWrapper(ResultSet resultSet, ColumnNameCache columnNameCache) {
        this.rs = resultSet;
        this.columnNameCache = columnNameCache;
    }

    ResultSet getTarget() {
        return this.rs;
    }

    public int findColumn(String columnName) throws SQLException {
        return this.columnNameCache.getIndexForColumnName(columnName, this);
    }

    public Array getArray(String colName) throws SQLException {
        return this.rs.getArray(this.findColumn(colName));
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.rs.updateArray(this.findColumn(columnName), x);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.rs.getAsciiStream(this.findColumn(columnName));
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.rs.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.rs.getBigDecimal(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.rs.getBigDecimal(this.findColumn(columnName), scale);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.rs.updateBigDecimal(this.findColumn(columnName), x);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.rs.getBinaryStream(this.findColumn(columnName));
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.rs.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.rs.getBlob(this.findColumn(columnName));
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.rs.updateBlob(this.findColumn(columnName), x);
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.rs.getBoolean(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.rs.updateBoolean(this.findColumn(columnName), x);
    }

    public byte getByte(String columnName) throws SQLException {
        return this.rs.getByte(this.findColumn(columnName));
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.rs.updateByte(this.findColumn(columnName), x);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.rs.getBytes(this.findColumn(columnName));
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.rs.updateBytes(this.findColumn(columnName), x);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.rs.getCharacterStream(this.findColumn(columnName));
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.rs.updateCharacterStream(this.findColumn(columnName), x, length);
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.rs.getClob(this.findColumn(columnName));
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.rs.updateClob(this.findColumn(columnName), x);
    }

    public Date getDate(String columnName) throws SQLException {
        return this.rs.getDate(this.findColumn(columnName));
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.rs.getDate(this.findColumn(columnName), cal);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.rs.updateDate(this.findColumn(columnName), x);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.rs.getDouble(this.findColumn(columnName));
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.rs.updateDouble(this.findColumn(columnName), x);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.rs.getFloat(this.findColumn(columnName));
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.rs.updateFloat(this.findColumn(columnName), x);
    }

    public int getInt(String columnName) throws SQLException {
        return this.rs.getInt(this.findColumn(columnName));
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.rs.updateInt(this.findColumn(columnName), x);
    }

    public long getLong(String columnName) throws SQLException {
        return this.rs.getLong(this.findColumn(columnName));
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.rs.updateLong(this.findColumn(columnName), x);
    }

    public Object getObject(String columnName) throws SQLException {
        return this.rs.getObject(this.findColumn(columnName));
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.rs.getObject(this.findColumn(columnName), map);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.rs.updateObject(this.findColumn(columnName), x);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.rs.updateObject(this.findColumn(columnName), x, scale);
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.rs.getRef(this.findColumn(columnName));
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.rs.updateRef(this.findColumn(columnName), x);
    }

    public short getShort(String columnName) throws SQLException {
        return this.rs.getShort(this.findColumn(columnName));
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.rs.updateShort(this.findColumn(columnName), x);
    }

    public String getString(String columnName) throws SQLException {
        return this.rs.getString(this.findColumn(columnName));
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.rs.updateString(this.findColumn(columnName), x);
    }

    public Time getTime(String columnName) throws SQLException {
        return this.rs.getTime(this.findColumn(columnName));
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.rs.getTime(this.findColumn(columnName), cal);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.rs.updateTime(this.findColumn(columnName), x);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.rs.getTimestamp(this.findColumn(columnName));
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.rs.updateTimestamp(this.findColumn(columnName), x);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.rs.getTimestamp(this.findColumn(columnName), cal);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.rs.getUnicodeStream(this.findColumn(columnName));
    }

    public URL getURL(String columnName) throws SQLException {
        return this.rs.getURL(this.findColumn(columnName));
    }

    public void updateNull(String columnName) throws SQLException {
        this.rs.updateNull(this.findColumn(columnName));
    }

    public int getConcurrency() throws SQLException {
        return this.rs.getConcurrency();
    }

    public int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    public int getRow() throws SQLException {
        return this.rs.getRow();
    }

    public int getType() throws SQLException {
        return this.rs.getType();
    }

    public void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    public void cancelRowUpdates() throws SQLException {
        this.rs.cancelRowUpdates();
    }

    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    public void close() throws SQLException {
        this.rs.close();
    }

    public void deleteRow() throws SQLException {
        this.rs.deleteRow();
    }

    public void insertRow() throws SQLException {
        this.rs.insertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.rs.moveToCurrentRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.rs.moveToInsertRow();
    }

    public void refreshRow() throws SQLException {
        this.rs.refreshRow();
    }

    public void updateRow() throws SQLException {
        this.rs.updateRow();
    }

    public boolean first() throws SQLException {
        return this.rs.first();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        return this.rs.last();
    }

    public boolean next() throws SQLException {
        return this.rs.next();
    }

    public boolean previous() throws SQLException {
        return this.rs.previous();
    }

    public boolean rowDeleted() throws SQLException {
        return this.rs.rowDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.rs.rowInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.rs.rowUpdated();
    }

    public boolean wasNull() throws SQLException {
        return this.rs.wasNull();
    }

    public byte getByte(int columnIndex) throws SQLException {
        return this.rs.getByte(columnIndex);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.rs.getDouble(columnIndex);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.rs.getFloat(columnIndex);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this.rs.getInt(columnIndex);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.rs.getLong(columnIndex);
    }

    public short getShort(int columnIndex) throws SQLException {
        return this.rs.getShort(columnIndex);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.rs.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.rs.setFetchSize(rows);
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.rs.updateNull(columnIndex);
    }

    public boolean absolute(int row) throws SQLException {
        return this.rs.absolute(row);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.rs.getBoolean(columnIndex);
    }

    public boolean relative(int rows) throws SQLException {
        return this.rs.relative(rows);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.rs.getBytes(columnIndex);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.rs.updateByte(columnIndex, x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.rs.updateDouble(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.rs.updateFloat(columnIndex, x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.rs.updateInt(columnIndex, x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.rs.updateLong(columnIndex, x);
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.rs.updateShort(columnIndex, x);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.rs.updateBoolean(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.rs.updateBytes(columnIndex, x);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.rs.getAsciiStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.rs.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.rs.getUnicodeStream(columnIndex);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.rs.updateAsciiStream(columnIndex, x, length);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.rs.updateBinaryStream(columnIndex, x, length);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.rs.getCharacterStream(columnIndex);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.rs.updateCharacterStream(columnIndex, x, length);
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.rs.getObject(columnIndex);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.rs.updateObject(columnIndex, x);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.rs.updateObject(columnIndex, x, scale);
    }

    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    public String getString(int columnIndex) throws SQLException {
        return this.rs.getString(columnIndex);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.rs.updateString(columnIndex, x);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.rs.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.rs.getBigDecimal(columnIndex, scale);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.rs.updateBigDecimal(columnIndex, x);
    }

    public URL getURL(int columnIndex) throws SQLException {
        return this.rs.getURL(columnIndex);
    }

    public Array getArray(int columnIndex) throws SQLException {
        return this.rs.getArray(columnIndex);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.rs.updateArray(columnIndex, x);
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return this.rs.getBlob(columnIndex);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.rs.updateBlob(columnIndex, x);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        return this.rs.getClob(columnIndex);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.rs.updateClob(columnIndex, x);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return this.rs.getDate(columnIndex);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.rs.updateDate(columnIndex, x);
    }

    public Ref getRef(int columnIndex) throws SQLException {
        return this.rs.getRef(columnIndex);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.rs.updateRef(columnIndex, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    public Statement getStatement() throws SQLException {
        return this.rs.getStatement();
    }

    public Time getTime(int columnIndex) throws SQLException {
        return this.rs.getTime(columnIndex);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.rs.updateTime(columnIndex, x);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.rs.getTimestamp(columnIndex);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.rs.updateTimestamp(columnIndex, x);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        return this.rs.getObject(columnIndex, map);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.rs.getDate(columnIndex, cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.rs.getTime(columnIndex, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.rs.getTimestamp(columnIndex, cal);
    }
}

