/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.concurrency;

public class Barrier {
    private int size = 0;
    private int counter = 0;
    private static final int COLLECTING = 0;
    private static final int OPENING = 1;
    private int state = 0;
    private Object entryLock = new Object();
    private Object openLock = new Object();

    protected Barrier(int size) {
        if (size < 2) {
            throw new IllegalArgumentException("size must be a minimum of 2!");
        }
        this.size = size;
    }

    protected synchronized void enter() {
        while (this.state != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        ++this.counter;
        if (this.size == this.counter) {
            this.state = 1;
            this.notifyAll();
        }
        while (this.state != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        --this.counter;
        if (this.counter == 0) {
            this.state = 0;
            this.notifyAll();
        }
    }
}

