/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.generator.repository;

import fr.toutatice.cartoun.generator.model.Academy;
import fr.toutatice.cartoun.generator.model.Configuration;
import fr.toutatice.cartoun.generator.repository.GenerateCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import io.codearte.jfairy.Fairy;
import io.codearte.jfairy.producer.company.Company;
import io.codearte.jfairy.producer.person.Person;
import io.codearte.jfairy.producer.person.PersonProperties;
import io.codearte.jfairy.producer.text.TextProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.naming.NameAlreadyBoundException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class GenerateCommand
implements INuxeoCommand {
    private static final String SEPARATOR = ",";
    private final Log log = LogFactory.getLog(this.getClass());
    private final InitialLdapContext ldapContext;
    private final Configuration configuration;
    private final Academy academy;
    private final Locale locale;
    private int errors;

    public GenerateCommand(InitialLdapContext ldapContext, Configuration configuration, Academy academy, Locale locale) {
        this.ldapContext = ldapContext;
        this.configuration = configuration;
        this.academy = academy;
        this.locale = locale;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        long start = System.currentTimeMillis();
        this.log.info((Object)("[" + this.academy.getLabel() + "] start"));
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        String path = "/" + this.academy.getName();
        boolean exists = true;
        try {
            documentService.getDocument((DocRef)new PathRef(path));
        }
        catch (Exception e) {
            exists = false;
        }
        if (!exists) {
            Document academy = this.createAcademy(nuxeoSession, documentService);
            Document poolsFolder = this.createStructuresFolder(nuxeoSession, documentService, academy, "Bapes");
            List pools = this.createPools(nuxeoSession, documentService, poolsFolder);
            Document institutionsFolder = this.createStructuresFolder(nuxeoSession, documentService, academy, "Etablissements");
            List institutions = this.createInstitutions(nuxeoSession, documentService, institutionsFolder, pools);
            List profiles = this.createProfiles();
            List users = this.createUsers(institutions, profiles);
            Document service = this.createService(nuxeoSession, documentService, academy);
            List folders = this.createFolders(nuxeoSession, documentService, service);
            this.createActivities(nuxeoSession, documentService, folders, users);
        }
        this.log.info((Object)("[" + this.academy.getLabel() + "] done (" + (System.currentTimeMillis() - start) + "ms)"));
        if (this.errors > 0) {
            this.log.warn((Object)(String.valueOf(this.errors) + " erreurs"));
        }
        return null;
    }

    private Document createAcademy(Session nuxeoSession, DocumentService documentService) throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation de l'acad\u00e9mie"));
        Document root = documentService.getRootDocument();
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", "ACA-" + this.academy.getCode());
        properties.set("dc:description", this.academy.getLabel());
        properties.set("ttc:webid", "aca_" + this.academy.getCode());
        return this.createDocument(nuxeoSession, documentService, root, "Domain", this.academy.getName(), properties);
    }

    private Document createStructuresFolder(Session nuxeoSession, DocumentService documentService, Document academy, String name) throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation de la structure '" + name + "'"));
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", name);
        return this.createDocument(nuxeoSession, documentService, academy, "Structures", StringUtils.lowerCase((String)name), properties);
    }

    private List<Document> createPools(Session nuxeoSession, DocumentService documentService, Document poolsFolder) throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation des bassins"));
        Fairy fairy = Fairy.create((Locale)this.locale);
        TextProducer textProducer = fairy.textProducer();
        Random random = new Random();
        ArrayList<Document> pools = new ArrayList<Document>(this.configuration.getPoolsCount());
        for (int i = 0; i < this.configuration.getPoolsCount(); ++i) {
            Person person = fairy.person(new PersonProperties.PersonProperty[0]);
            String name = "bape-" + String.valueOf(i + 1);
            String displayName = "Bassin " + StringUtils.leftPad((String)String.valueOf(i + 1), (int)2, (String)"0");
            String rne = StringUtils.leftPad((String)String.valueOf(random.nextInt(9999999)), (int)7, (String)"0") + String.valueOf((char)(random.nextInt(26) + 65));
            PropertyMap properties = new PropertyMap();
            properties.set("dc:title", displayName);
            properties.set("ttc:webid", "bape_" + rne);
            properties.set("bape:ENTDisplayName", displayName);
            properties.set("bape:description", textProducer.sentence().replaceAll("\\r|\\n", ""));
            properties.set("bape:ENTStructureTypeStruct", textProducer.word(1).replaceAll(",|;", ""));
            properties.set("bape:ENTCodeAcademie", "ACA-" + this.academy.getCode());
            properties.set("bape:ou", rne);
            properties.set("bape:l", person.getAddress().getCity());
            try {
                ArrayList<Permission> permissions = new ArrayList<Permission>(1);
                permissions.add(new Permission(this, "personnel-tous", "Read"));
                Document pool = this.createDocument(nuxeoSession, documentService, poolsFolder, "ENTbape", name, properties, permissions);
                pools.add(pool);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pools;
    }

    private List<Document> createInstitutions(Session nuxeoSession, DocumentService documentService, Document institutionsFolder, List<Document> pools) throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation des \u00e9tablissements"));
        Fairy fairy = Fairy.create((Locale)this.locale);
        TextProducer textProducer = fairy.textProducer();
        Random random = new Random();
        int count = this.configuration.getInstitutionsCount() / this.configuration.getPoolsCount();
        int progression = 1;
        ArrayList<Document> institutions = new ArrayList<Document>(this.configuration.getInstitutionsCount());
        for (Document pool : pools) {
            for (int i = 0; i < count; ++i) {
                if (progression % 10 == 0) {
                    this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation des \u00e9tablissements (" + String.valueOf(progression) + "/" + String.valueOf(this.configuration.getInstitutionsCount()) + ")"));
                }
                ++progression;
                Person person = fairy.person(new PersonProperties.PersonProperty[0]);
                String name = "etb-" + String.valueOf(i + 1) + "-" + StringUtils.substringAfterLast((String)pool.getPath(), (String)"/");
                String displayName = "\u00c9tablissement " + StringUtils.leftPad((String)String.valueOf(i + 1), (int)2, (String)"0") + " (" + pool.getTitle() + ")";
                String rne = StringUtils.leftPad((String)String.valueOf(random.nextInt(9999999)), (int)7, (String)"0") + String.valueOf((char)(random.nextInt(26) + 65));
                PropertyMap properties = new PropertyMap();
                properties.set("dc:title", displayName);
                properties.set("ttc:webid", "etb_" + rne);
                properties.set("etb:ENTDisplayName", displayName);
                properties.set("etb:ENTStructureNomCourant", textProducer.word(1).replaceAll(",|;", ""));
                properties.set("etb:description", textProducer.sentence().replaceAll("\\r|\\n", ""));
                properties.set("etb:ENTEtablissementBassin", pool.getString("ttc:webid"));
                properties.set("etb:ENTEtablissementContrat", person.passportNumber());
                properties.set("etb:ENTEtablissementMinistereTutelle", textProducer.word(1).replaceAll(",|;", ""));
                properties.set("etb:ou", rne);
                properties.set("etb:ENTCodeAcademie", "ACA-" + this.academy.getCode());
                properties.set("etb:ENTOrganisationGeoLoc", this.generateGeolocation(random));
                properties.set("etb:ENTStructureTypeStruct", textProducer.word(1).replaceAll(",|;", ""));
                properties.set("etb:telephoneNumber", person.telephoneNumber());
                properties.set("etb:facsimileTelephoneNumber", person.telephoneNumber());
                properties.set("etb:street", person.getAddress().street());
                properties.set("etb:postalCode", person.getAddress().getPostalCode());
                properties.set("etb:l", person.getAddress().getCity());
                try {
                    Document institution = this.createDocument(nuxeoSession, documentService, institutionsFolder, "ENTEtablissement", name, properties);
                    institutions.add(institution);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return institutions;
    }

    private List<String> createProfiles() throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation des profils"));
        ArrayList<String> profiles = new ArrayList<String>(this.configuration.getDisciplines().size() * this.configuration.getProfiles().size());
        for (String discipline : this.configuration.getDisciplines()) {
            for (String profile : this.configuration.getProfiles()) {
                String cn = this.academy.getCode() + "-" + discipline + "-" + profile;
                String displayName = discipline + " - " + profile + " (" + this.academy.getLabel() + ")";
                LdapName ldapName = new LdapName(this.configuration.getProfilesBaseDn());
                ldapName.add("cn=" + cn);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put("ENTProfilPeuplement", "EXPLICITE");
                attributes.put("ENTProfilType", "space-group");
                attributes.put("ENTDisplayName", displayName);
                BasicAttribute objectClass = new BasicAttribute("objectclass");
                objectClass.add("groupOfNames");
                objectClass.add("top");
                objectClass.add("ENTProfil");
                attributes.put(objectClass);
                try {
                    this.ldapContext.createSubcontext(ldapName, (Attributes)attributes);
                    profiles.add(ldapName.toString());
                }
                catch (NameAlreadyBoundException e) {
                    profiles.add(ldapName.toString());
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return profiles;
    }

    private List<String> createUsers(List<Document> institutions, List<String> profiles) throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation des utilisateurs"));
        Fairy fairy = Fairy.create((Locale)this.locale);
        TextProducer textProducer = fairy.textProducer();
        Random random = new Random();
        ArrayList<String> users = new ArrayList<String>(this.configuration.getUsersCount());
        for (int i = 0; i < this.configuration.getUsersCount(); ++i) {
            Person person = fairy.person(new PersonProperties.PersonProperty[0]);
            String username = person.username().replaceAll(" ", "");
            String uid = username + "@" + this.academy.getCode();
            float p = random.nextFloat();
            int count = (double)p > 0.9 ? 3 : ((double)p > 0.75 ? 2 : 1);
            HashSet<String> userInstitutions = new HashSet<String>(count);
            for (int j = 0; j < count; ++j) {
                Document institution = institutions.get(random.nextInt(institutions.size()));
                userInstitutions.add(StringUtils.removeStart((String)institution.getString("ttc:webid"), (String)"etb_"));
            }
            p = random.nextFloat();
            String profile = (double)p > 0.1 ? profiles.get(random.nextInt(profiles.size())) : null;
            LdapName ldapName = new LdapName(this.configuration.getUsersBaseDn());
            ldapName.add("uid=" + uid);
            BasicAttributes attributes = new BasicAttributes();
            attributes.put("cn", person.fullName());
            attributes.put("sn", person.lastName());
            attributes.put("givenName", person.firstName());
            attributes.put("displayName", person.fullName());
            attributes.put("userPassword", "osivia");
            attributes.put("mail", "lbillon+" + username + "@osivia.com");
            attributes.put("title", person.isFemale() ? "Mme" : "M.");
            attributes.put("ENTCodeAcademie", this.academy.getCode());
            attributes.put("ENTPersonAlias", textProducer.word(1));
            attributes.put("ENTPersonDateNaissance", person.dateOfBirth().toString());
            attributes.put("ENTPersonListeRouge", String.valueOf(random.nextBoolean()));
            if (profile != null) {
                attributes.put("ENTPersonProfils", profile);
                BasicAttribute members = new BasicAttribute("member");
                members.add(ldapName.toString());
                BasicAttribute explicitMembers = new BasicAttribute("ExplicitMember");
                explicitMembers.add(ldapName.toString());
                ModificationItem[] modifications = new ModificationItem[]{new ModificationItem(1, members), new ModificationItem(1, explicitMembers)};
                this.ldapContext.modifyAttributes(profile, modifications);
            }
            BasicAttribute objectClass = new BasicAttribute("objectclass");
            objectClass.add("person");
            objectClass.add("inetOrgPerson");
            objectClass.add("organizationalPerson");
            objectClass.add("top");
            objectClass.add("ENTPerson");
            attributes.put(objectClass);
            BasicAttribute rne = new BasicAttribute("Rne");
            for (String institution : userInstitutions) {
                rne.add(institution);
            }
            attributes.put(rne);
            BasicAttribute fonctions = new BasicAttribute("ENTPersonFonctions");
            List<String> list = Arrays.asList(StringUtils.split((String)textProducer.word(random.nextInt(3) + 1)));
            for (String fonction : list) {
                fonctions.add(fonction);
            }
            attributes.put(fonctions);
            try {
                this.ldapContext.createSubcontext(ldapName, (Attributes)attributes);
                users.add(ldapName.toString());
                continue;
            }
            catch (NameAlreadyBoundException e) {
                users.add(ldapName.toString());
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return users;
    }

    private Document createService(Session nuxeoSession, DocumentService documentService, Document academy) throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation du SAP"));
        String name = "sap";
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", this.academy.getLabel());
        properties.set("ttc:webid", "sun_" + this.academy.getCode());
        properties.set("ttc:isPreloadedOnLogin", Boolean.valueOf(true));
        properties.set("ttc:tabOrder", String.valueOf(NumberUtils.toInt((String)this.academy.getCode())));
        ArrayList<Permission> permissions = new ArrayList<Permission>(1);
        permissions.add(new Permission(this, "personnel-tous", "Read"));
        return this.createDocument(nuxeoSession, documentService, academy, "UsageNumServiceMetier", name, properties, true, permissions);
    }

    private List<Document> createFolders(Session nuxeoSession, DocumentService documentService, Document service) throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation des DAP"));
        Fairy fairy = Fairy.create((Locale)this.locale);
        ArrayList<Document> folders = new ArrayList<Document>(this.configuration.getFoldersCount());
        for (int i = 0; i < this.configuration.getFoldersCount(); ++i) {
            TextProducer textProducer = fairy.textProducer();
            String name = "dap-" + String.valueOf(i + 1);
            PropertyMap properties = new PropertyMap();
            properties.set("dc:title", "DAP " + StringUtils.leftPad((String)String.valueOf(i + 1), (int)2, (String)"0"));
            properties.set("ttc:webid", "dun_" + this.academy.getCode() + "_" + name);
            properties.set("dun:subtitle", textProducer.sentence().replaceAll("\\r|\\n", ""));
            try {
                ArrayList<Permission> permissions = new ArrayList<Permission>(this.configuration.getDisciplines().size() * this.configuration.getProfiles().size());
                for (String discipline : this.configuration.getDisciplines()) {
                    for (String profile : this.configuration.getProfiles()) {
                        String user = this.academy.getCode() + "-" + discipline + "-" + profile;
                        String right = "IPR".equals(profile) || "IAN".equals(profile) ? "Everything" : "Write";
                        permissions.add(new Permission(this, user, right));
                    }
                }
                Document folder = this.createDocument(nuxeoSession, documentService, service, "UsageNumDossier", name, properties, true, permissions);
                folders.add(folder);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return folders;
    }

    private void createActivities(Session nuxeoSession, DocumentService documentService, List<Document> folders, List<String> users) throws Exception {
        this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation des activit\u00e9s"));
        Fairy fairy = Fairy.create((Locale)this.locale);
        TextProducer textProducer = fairy.textProducer();
        Random random = new Random();
        int count = this.configuration.getActivitiesCount() / this.configuration.getFoldersCount();
        int progression = 1;
        List modalitesRecords = this.getRecords("unu_modalite");
        List disciplinesRecords = this.getRecords("disciplines");
        List naturesPedagogiquesRecords = this.getRecords("unu_naturepeda");
        List niveauxEducatifsRecords = this.getRecords("niveauxEducatifs");
        List lieuxRecords = this.getRecords("unu_lieu");
        List outilsRecords = this.getRecords("unu_outils_child1");
        List transferabiliteRecords = this.getRecords("unu_transferabilite");
        List pratiquesRecords = this.getRecords("unu_pratiques");
        List axesRecords = this.getRecords("carto_axes");
        List dureesRecords = this.getRecords("unu_duree");
        List niveauxRecords = this.getRecords("unu_niveau");
        List parcoursRecords = this.getRecords("carto_parcours");
        List niveauxReferentRecords = this.getRecords("unu_niveauReferent");
        for (Document folder : folders) {
            for (int i = 0; i < count; ++i) {
                String id2;
                if (progression % 10 == 0) {
                    this.log.info((Object)("[" + this.academy.getLabel() + "] Cr\u00e9ation des activit\u00e9s (" + String.valueOf(progression) + "/" + String.valueOf(this.configuration.getActivitiesCount()) + ")"));
                }
                ++progression;
                float f = random.nextFloat();
                int v = (double)f > 0.9 ? 3 : ((double)f > 0.75 ? 2 : 1);
                HashSet<String> modalites = new HashSet<String>(v);
                HashSet<String> disciplines = new HashSet<String>(v);
                HashSet<String> naturesPedagogiques = new HashSet<String>(v);
                HashSet<String> niveauxEducatifs = new HashSet<String>(v);
                HashSet<String> lieux = new HashSet<String>(v);
                HashSet<String> outils = new HashSet<String>(v);
                HashSet<String> pratiques = new HashSet<String>(v);
                HashSet<String> axes = new HashSet<String>(v);
                HashSet<String> parcours = new HashSet<String>(v);
                for (int j = 0; j < v; ++j) {
                    String parent;
                    modalites.add(((CSVRecord)modalitesRecords.get(random.nextInt(modalitesRecords.size()))).get("id"));
                    CSVRecord discipline = (CSVRecord)disciplinesRecords.get(random.nextInt(disciplinesRecords.size()));
                    disciplines.add(discipline.get("parent") + "/" + discipline.get("id"));
                    naturesPedagogiques.add(((CSVRecord)naturesPedagogiquesRecords.get(random.nextInt(naturesPedagogiquesRecords.size()))).get("id"));
                    CSVRecord niveauEducatifRecord = (CSVRecord)niveauxEducatifsRecords.get(random.nextInt(niveauxEducatifsRecords.size()));
                    String niveauEducatif = niveauEducatifRecord.get("id");
                    block5: while (niveauEducatifRecord != null && (parent = niveauEducatifRecord.get("parent")) != null && !"__NULL__".equals(parent)) {
                        niveauEducatifRecord = null;
                        for (CSVRecord record : niveauxEducatifsRecords) {
                            id2 = record.get("id");
                            if (!parent.equals(id2)) continue;
                            niveauEducatifRecord = record;
                            niveauEducatif = id2 + "/" + niveauEducatif;
                            continue block5;
                        }
                    }
                    niveauxEducatifs.add(niveauEducatif);
                    lieux.add(((CSVRecord)lieuxRecords.get(random.nextInt(lieuxRecords.size()))).get("id"));
                    CSVRecord outil = (CSVRecord)outilsRecords.get(random.nextInt(outilsRecords.size()));
                    outils.add(outil.get("parent") + "/" + outil.get("id"));
                    pratiques.add(((CSVRecord)pratiquesRecords.get(random.nextInt(pratiquesRecords.size()))).get("id"));
                    axes.add(((CSVRecord)axesRecords.get(random.nextInt(axesRecords.size()))).get("id"));
                    parcours.add(((CSVRecord)parcoursRecords.get(random.nextInt(parcoursRecords.size()))).get("id"));
                }
                String name = "act-" + String.valueOf(i + 1) + "-" + StringUtils.substringAfterLast((String)folder.getPath(), (String)"/");
                PropertyMap properties = new PropertyMap();
                properties.set("dc:title", "Activit\u00e9 " + StringUtils.leftPad((String)String.valueOf(i + 1), (int)2, (String)"0") + " (" + folder.getTitle() + ")");
                properties.set("acrp:activites", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:cadresUtilisations", StringUtils.join(modalites, (String)","));
                properties.set("acrp:competences", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:disciplines", StringUtils.join(disciplines, (String)","));
                properties.set("acrp:langues", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:naturesPedagogiques", StringUtils.join(naturesPedagogiques, (String)","));
                properties.set("acrp:niveauxCompetences", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:niveauxEducatifs", StringUtils.join(niveauxEducatifs, (String)","));
                properties.set("acrp:publicsCibles", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:sdCompetences", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:sdNiveauxCompetences", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:sdThemes", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:sousDomaines", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:themes", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("acrp:lieu", StringUtils.join(lieux, (String)","));
                properties.set("acrp:outils", StringUtils.join(outils, (String)","));
                properties.set("acrp:transferabilite", ((CSVRecord)transferabiliteRecords.get(random.nextInt(transferabiliteRecords.size()))).get("id"));
                properties.set("acrp:pratique", StringUtils.join(pratiques, (String)","));
                properties.set("unum:analyse", textProducer.sentence().replaceAll("\\r|\\n", ""));
                properties.set("unum:axe", StringUtils.join(axes, (String)","));
                properties.set("unum:duree", ((CSVRecord)dureesRecords.get(random.nextInt(dureesRecords.size()))).get("id"));
                properties.set("unum:experitheque", textProducer.sentence().replaceAll("\\r|\\n", ""));
                properties.set("unum:groupeViaeduc", textProducer.sentence().replaceAll("\\r|\\n", ""));
                properties.set("unum:logicielLocal", StringUtils.join((Object[])StringUtils.split((String)textProducer.word(random.nextInt(3) + 1).replaceAll(",|;", "")), (String)","));
                properties.set("unum:natPedaAutre", textProducer.sentence().replaceAll("\\r|\\n", ""));
                properties.set("unum:niv", ((CSVRecord)niveauxRecords.get(random.nextInt(niveauxRecords.size()))).get("id"));
                properties.set("unum:parcours", StringUtils.join(parcours, (String)","));
                properties.set("unum:piege", textProducer.sentence().replaceAll("\\r|\\n", ""));
                properties.set("unum:resume", textProducer.sentence().replaceAll("\\r|\\n", ""));
                properties.set("unum:scenario", textProducer.sentence().replaceAll("\\r|\\n", ""));
                properties.set("unum:urlExpe", fairy.company().url());
                int p = random.nextInt(3) + 1;
                JSONArray internetSoftwares = new JSONArray();
                for (int j = 0; j < p; ++j) {
                    Company company = fairy.company();
                    JSONObject software = new JSONObject();
                    software.put((Object)"name", (Object)company.name());
                    software.put((Object)"url", (Object)company.url());
                    internetSoftwares.add((Object)software);
                }
                properties.set("unum:logicielInternet", internetSoftwares.toString());
                HashSet<String> ids = new HashSet<String>(this.configuration.getReferrersCount());
                for (int j = 0; j < this.configuration.getReferrersCount(); ++j) {
                    String user = users.get(random.nextInt(users.size()));
                    Attributes userAttributes = this.ldapContext.getAttributes(user);
                    id2 = (String)userAttributes.get("uid").get();
                    ids.add(id2.toString());
                }
                JSONArray referrers = new JSONArray();
                boolean owner = true;
                for (String id2 : ids) {
                    JSONObject referrer = new JSONObject();
                    referrer.put((Object)"uid", (Object)id2);
                    referrer.put((Object)"niveau", (Object)((CSVRecord)niveauxReferentRecords.get(random.nextInt(niveauxReferentRecords.size()))).get("id"));
                    referrer.put((Object)"owner", (Object)owner);
                    owner = false;
                    referrers.add((Object)referrer);
                }
                properties.set("unum:referents", referrers.toString());
                JSONObject applicationSoftware = new JSONObject();
                JSONArray local = new JSONArray();
                local.add((Object)fairy.company().name());
                applicationSoftware.put((Object)"local", (Object)local);
                p = random.nextInt(3) + 1;
                JSONArray links = new JSONArray();
                for (int k = 0; k < p; ++k) {
                    Person person = fairy.person(new PersonProperties.PersonProperty[0]);
                    JSONObject link = new JSONObject();
                    link.put((Object)"nom", (Object)person.fullName());
                    link.put((Object)"adresse", (Object)person.getAddress().toString());
                    links.add((Object)link);
                }
                applicationSoftware.put((Object)"internet", (Object)links);
                properties.set("unula:logicielAppli", applicationSoftware.toString());
                try {
                    this.createDocument(nuxeoSession, documentService, folder, "UsageNum", name, properties, true);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private Document createDocument(Session nuxeoSession, DocumentService documentService, Document parent, String type, String name, PropertyMap properties) throws Exception {
        return this.createDocument(nuxeoSession, documentService, parent, type, name, properties, false);
    }

    private Document createDocument(Session nuxeoSession, DocumentService documentService, Document parent, String type, String name, PropertyMap properties, List<Permission> permissions) throws Exception {
        return this.createDocument(nuxeoSession, documentService, parent, type, name, properties, false, permissions);
    }

    private Document createDocument(Session nuxeoSession, DocumentService documentService, Document parent, String type, String name, PropertyMap properties, boolean publish) throws Exception {
        return this.createDocument(nuxeoSession, documentService, parent, type, name, properties, false, null);
    }

    private Document createDocument(Session nuxeoSession, DocumentService documentService, Document parent, String type, String name, PropertyMap properties, boolean publish, List<Permission> permissions) throws Exception {
        Document document;
        try {
            String path = StringUtils.removeEnd((String)parent.getPath(), (String)"/") + "/" + name;
            document = documentService.getDocument((DocRef)new PathRef(path));
        }
        catch (Exception e1) {
            try {
                document = documentService.createDocument((DocRef)parent, type, name, properties);
                if (permissions != null) {
                    for (Permission permission : permissions) {
                        document = documentService.setPermission((DocRef)document, Permission.access$000((Permission)permission), Permission.access$100((Permission)permission));
                    }
                }
                if (publish) {
                    OperationRequest request = nuxeoSession.newRequest("setOnLine").setInput((OperationInput)document);
                    request.execute();
                }
            }
            catch (Exception e2) {
                this.log.error((Object)("[" + this.academy.getLabel() + "] Erreur de cr\u00e9ation avec les donn\u00e9es suivantes :"));
                this.log.error((Object)("   name = '" + name + "'"));
                this.log.error((Object)("   properties = '" + properties + "'"));
                ++this.errors;
                throw e2;
            }
        }
        String webId = properties.getString("ttc:webid");
        if (StringUtils.isNotEmpty((String)webId)) {
            document.set("ttc:webid", webId);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CSVRecord> getRecords(String name) throws IOException {
        List records = null;
        try (CSVParser parser = null;){
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("csv/" + name + ".csv");
            InputStreamReader reader = new InputStreamReader(in);
            parser = new CSVParser((Reader)reader, CSVFormat.DEFAULT.withHeader(new String[0]));
            records = parser.getRecords();
        }
        return records;
    }

    private String generateGeolocation(Random random) {
        double latitude = random.nextDouble() * 9.0 + 42.0;
        double longitude = random.nextDouble() * 12.0 - 4.0;
        return String.valueOf(latitude) + "," + String.valueOf(longitude);
    }

    public String getId() {
        return this.academy.getCode();
    }
}

