/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.racvisiontest;

import fr.edu.toulouse.commons.racvision.report.TestResultStateEnum;
import fr.edu.toulouse.commons.racvision.test.AbstractRacVisionTest;
import fr.edu.toulouse.commons.racvision.test.RacVisionTestResult;
import fr.edu.toulouse.commons.racvision.test.State;
import fr.toutatice.cartoun.racvisiontest.NuxeoRacvisionTest;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.status.IStatusService;

public class StatusServiceRacvisionTest
extends AbstractRacVisionTest {
    private static final Log LOGGER = LogFactory.getLog(NuxeoRacvisionTest.class);
    private final PortletContext portletContext;

    public StatusServiceRacvisionTest(PortletContext portletContext, String idTest, boolean required, String description, boolean duration) {
        this.portletContext = portletContext;
        this.setValeur(idTest, required, description, duration);
    }

    public List<RacVisionTestResult> run() {
        ArrayList<RacVisionTestResult> resultats = new ArrayList<RacVisionTestResult>();
        RacVisionTestResult resultat = new RacVisionTestResult(this.getId(), this.isRequired(), this.getDescription());
        resultats.add(resultat);
        resultat.setState(new State(TestResultStateEnum.CRIT, "Connexion \u00e0 Nuxeo impossible."));
        ArrayList<String> listParamAbsent = new ArrayList<String>();
        if (this.portletContext == null) {
            listParamAbsent.add("contexte de connexion \u00e0 Nuxeo");
        }
        if (!listParamAbsent.isEmpty()) {
            StringBuffer message = new StringBuffer("Au moins un param\u00e8tre attendu par la m\u00e9thode est absent, le test n'a pu \u00eatre r\u00e9alis\u00e9. Param\u00e8tre(s) manquant(s) : ");
            for (String paramAbsent : listParamAbsent) {
                message.append(paramAbsent).append(", ");
            }
            String strMsg = message.substring(0, message.length() - 2);
            resultat.setState(new State(TestResultStateEnum.CRIT, strMsg + "."));
            return resultats;
        }
        try {
            IStatusService serviceStatut = (IStatusService)this.getPortletContext().getAttribute("StatusService");
            boolean ready = serviceStatut.isReady(NuxeoConnectionProperties.getPrivateBaseUri().toString());
            if (!ready) {
                resultat.setState(new State(TestResultStateEnum.CRIT, "Status indisponible."));
            } else {
                resultat.setState(new State(TestResultStateEnum.OK));
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            resultat.setState(new State(TestResultStateEnum.CRIT, "Impossible d'appeller le service de status."));
        }
        return resultats;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }
}

