/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.pointcut.Pointcut;

public abstract class JoinpointClassifier {
    private Matcher fieldGetMatcher = new Matcher(){

        public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException {
            return pointcut.matchesGet(advisor, (CtField)member);
        }
    };
    private Matcher fieldSetMatcher = new Matcher(){

        public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException {
            return pointcut.matchesSet(advisor, (CtField)member);
        }
    };
    private Matcher constructorMatcher = new Matcher(){

        public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException {
            return pointcut.matchesExecution(advisor, (CtConstructor)member);
        }
    };
    private Matcher methodMatcher = new Matcher(){

        public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException {
            return pointcut.matchesExecution(advisor, (CtMethod)member);
        }
    };

    protected abstract JoinpointClassification classifyJoinpoint(CtMember var1, Advisor var2, Matcher var3) throws NotFoundException;

    public JoinpointClassification classifyFieldGet(CtField field, Advisor advisor) throws NotFoundException {
        return this.classifyJoinpoint((CtMember)field, advisor, this.fieldGetMatcher);
    }

    public JoinpointClassification classifyFieldSet(CtField field, Advisor advisor) throws NotFoundException {
        return this.classifyJoinpoint((CtMember)field, advisor, this.fieldSetMatcher);
    }

    public JoinpointClassification classifyConstructorExecution(CtConstructor cons, Advisor advisor) throws NotFoundException {
        return this.classifyJoinpoint((CtMember)cons, advisor, this.constructorMatcher);
    }

    public JoinpointClassification classifyMethodExecution(CtMethod method, Advisor advisor) throws NotFoundException {
        return this.classifyJoinpoint((CtMember)method, advisor, this.methodMatcher);
    }

    protected static interface Matcher {
        public boolean matches(Pointcut var1, Advisor var2, CtMember var3) throws NotFoundException;
    }
}

