/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class JarUtils {
    private JarUtils() {
    }

    public static Manifest getManifest(File file) {
        try {
            if (file.isDirectory()) {
                return JarUtils.getDirectoryManifest(file);
            }
            return JarUtils.getJarManifest(file);
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static Manifest getDirectoryManifest(File file) throws IOException {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(new File(file, "META-INF/MANIFEST.MF"));
            Manifest manifest = new Manifest(fis);
            return manifest;
        }
    }

    public static Manifest getJarManifest(File file) throws IOException {
        try (JarFile jar = null;){
            jar = new JarFile(file);
            Manifest manifest = jar.getManifest();
            return manifest;
        }
    }

    public static Manifest getManifest(URL url) {
        try {
            return new JarFile(new File(url.getFile())).getManifest();
        }
        catch (IOException e) {
            return null;
        }
    }
}

