/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.elasticsearch.api.OttcElasticSearchIndexing;
import org.opentoutatice.elasticsearch.config.OttcElasticSearchIndexOrAliasConfig;
import org.opentoutatice.elasticsearch.core.reindexing.docs.exception.IndexException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.index.IndexName;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.exception.ReIndexingException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.transitory.TransitoryIndexUse;

public class IndexNAliasManager {
    private static final Log log = LogFactory.getLog(IndexNAliasManager.class);
    private static final String FORMER_ALIAS_PREFIX = "former-";
    private OttcElasticSearchIndexing elasticSearchIndexing;
    private AdminClient adminClient;
    private static IndexNAliasManager instance;

    private IndexNAliasManager(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public static synchronized void init(AdminClient adminClient) {
        Validate.isTrue((instance == null ? 1 : 0) != 0);
        instance = new IndexNAliasManager(adminClient);
    }

    public static synchronized IndexNAliasManager get() {
        return instance;
    }

    public Boolean indexExists(String indexName) {
        return ((IndicesExistsResponse)this.getAdminClient().indices().prepareExists(new String[]{indexName}).execute().actionGet()).isExists();
    }

    public List<String> getIndices() {
        ArrayList<String> indices = null;
        ImmutableOpenMap indicesMap = ((ClusterStateResponse)this.getAdminClient().cluster().prepareState().get()).getState().getMetaData().getIndices();
        if (indicesMap != null) {
            indices = new ArrayList<String>();
            UnmodifiableIterator indicesIt = indicesMap.keysIt();
            while (indicesIt.hasNext()) {
                String index = (String)indicesIt.next();
                indices.add(index);
            }
        }
        return indices;
    }

    public Boolean aliasExists(String aliasName) {
        return ((AliasesExistResponse)this.getAdminClient().indices().prepareAliasesExist(new String[]{aliasName}).execute().actionGet()).isExists();
    }

    public String getIndexOfAlias(String alias) {
        return (String)((GetAliasesResponse)this.getAdminClient().indices().prepareGetAliases(new String[]{alias}).get()).getAliases().keysIt().next();
    }

    public List<String> getIndicesOfAlias(String alias) throws NoSuchElementException {
        ArrayList<String> indices = null;
        ImmutableOpenMap aliases = ((GetAliasesResponse)this.getAdminClient().indices().prepareGetAliases(new String[]{alias}).get()).getAliases();
        if (aliases != null && aliases.size() > 0) {
            indices = new ArrayList<String>();
            UnmodifiableIterator keysIt = aliases.keysIt();
            while (keysIt.hasNext()) {
                String index = (String)keysIt.next();
                if (index == null) continue;
                indices.add(index);
            }
        } else {
            throw new NoSuchElementException(String.format("Alias [%s] does not exist.", alias));
        }
        return indices;
    }

    public synchronized String getTransientAlias(String repositoryName, TransitoryIndexUse use) {
        String alias = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Getting %s alias for repository [%s] ", use.getAlias(), repositoryName));
        }
        alias = TransitoryIndexUse.Read.equals((Object)use) ? TransitoryIndexUse.Read.getAlias() : TransitoryIndexUse.Write.getAlias();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("%s alias for repository [%s]: [%s] ", use.getAlias(), repositoryName, alias));
        }
        return alias;
    }

    public Boolean mayTransientAliasesExist() {
        return this.aliasExists(TransitoryIndexUse.Read.getAlias()) != false || this.aliasExists(TransitoryIndexUse.Write.getAlias()) != false;
    }

    public Boolean transientAliasesExist() {
        return this.aliasExists(TransitoryIndexUse.Read.getAlias()) != false && this.aliasExists(TransitoryIndexUse.Write.getAlias()) != false;
    }

    public OttcElasticSearchIndexOrAliasConfig createNewIndex(IndexName newIndexName, OttcElasticSearchIndexOrAliasConfig nxAliasCfg) throws IndexException, InterruptedException, ExecutionException {
        String newIndex;
        OttcElasticSearchIndexOrAliasConfig transientCfg = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"About to create new index ...");
        }
        if (this.indexExists(newIndex = newIndexName.toString()).booleanValue()) {
            throw new IndexException(String.format("Index [%s] yet exists.", transientCfg));
        }
        this.getAdminClient().indices().prepareCreate(newIndex).setSettings(nxAliasCfg.getSettings()).get();
        this.getAdminClient().indices().preparePutMapping(new String[]{newIndex}).setType(nxAliasCfg.getType()).setSource(nxAliasCfg.getMapping()).get();
        transientCfg = nxAliasCfg.clone();
        transientCfg.setName(newIndex);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("New index [%s] created.", transientCfg));
        }
        return transientCfg;
    }

    public void createAliasFor(String indexName, String aliasName) {
        this.getAdminClient().indices().prepareAliases().addAlias(indexName, aliasName).get();
    }

    public void createTransientAliases(IndexName initialIndex, IndexName newIndex) throws ReIndexingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("About to create transient aliases: [%s on (%s, %s) | %s on %s]...", TransitoryIndexUse.Read.getAlias(), initialIndex.toString(), newIndex.toString(), TransitoryIndexUse.Write.getAlias(), newIndex.toString()));
        }
        try {
            this.getAdminClient().indices().prepareAliases().addAlias(initialIndex.toString(), TransitoryIndexUse.Read.getAlias()).addAlias(newIndex.toString(), TransitoryIndexUse.Read.getAlias()).addAlias(newIndex.toString(), TransitoryIndexUse.Write.getAlias()).get();
        }
        catch (ElasticsearchException e) {
            throw new ReIndexingException((Exception)((Object)e));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Transient aliases: [%s on (%s, %s) | %s on %s] created.", TransitoryIndexUse.Read.getAlias(), initialIndex.toString(), newIndex.toString(), TransitoryIndexUse.Write.getAlias(), newIndex.toString()));
        }
    }

    public void updateEsAlias(String aliasName, IndexName initialIndex, IndexName newIndex) throws ReIndexingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("About to update [%s] alias: switch from [%s] index to [%s] index ...", aliasName, initialIndex.toString(), newIndex.toString()));
        }
        try {
            this.getAdminClient().indices().prepareAliases().addAlias(newIndex.toString(), aliasName).removeAlias(initialIndex.toString(), aliasName).get();
        }
        catch (ElasticsearchException e) {
            throw new ReIndexingException((Exception)((Object)e));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Alias [%s] updated: switched from [%s] index to [%s] index.", aliasName, initialIndex.toString(), newIndex.toString()));
        }
    }

    public void updateEsFormerAlias(String aliasName, IndexName initialIndex) throws ReIndexingException {
        String formerAlias = this.getFormerAliasName(aliasName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("About to update [%s] alias to [%s] index ...", formerAlias, initialIndex.toString()));
        }
        try {
            if (this.aliasExists(aliasName).booleanValue()) {
                String formerIndex = this.getIndexOfAlias(aliasName);
                this.getAdminClient().indices().prepareAliases().removeAlias(formerIndex, formerAlias);
            }
            this.getAdminClient().indices().prepareAliases().addAlias(initialIndex.toString(), formerAlias).get();
        }
        catch (ElasticsearchException e) {
            throw new ReIndexingException((Exception)((Object)e));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Alias [%s] updated to [%s] index.", formerAlias, initialIndex.toString()));
        }
    }

    public void fixAlias(String aliasName, String currentIndex, IndexName initialIndex) throws ReIndexingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("About to fix [%s] alias: setting to [%s] index ...", aliasName, initialIndex.toString()));
        }
        try {
            this.getAdminClient().indices().prepareAliases().removeAlias(currentIndex, aliasName).addAlias(initialIndex.toString(), aliasName).get();
        }
        catch (ElasticsearchException e) {
            throw new ReIndexingException((Exception)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("ALias [%s] fixed: set to [%s] index", aliasName, initialIndex.toString()));
        }
    }

    public String getFormerAliasName(String aliasName) {
        return FORMER_ALIAS_PREFIX.concat(aliasName);
    }

    public void deleteTransientAliases(IndexName initialIndex, IndexName newIndex) throws ReIndexingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("About to delete transient aliases: [%s on (%s, %s) | %s on %s] ...", TransitoryIndexUse.Read.getAlias(), initialIndex.toString(), newIndex.toString(), TransitoryIndexUse.Write.getAlias(), newIndex.toString()));
        }
        try {
            this.getAdminClient().indices().prepareAliases().removeAlias(initialIndex.toString(), TransitoryIndexUse.Read.getAlias()).removeAlias(newIndex.toString(), TransitoryIndexUse.Read.getAlias()).removeAlias(newIndex.toString(), TransitoryIndexUse.Write.getAlias()).get();
        }
        catch (ElasticsearchException e) {
            throw new ReIndexingException((Exception)((Object)e));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Transient aliases: [%s on (%s, %s) | %s on %s] deleted.", TransitoryIndexUse.Read.getAlias(), initialIndex.toString(), newIndex.toString(), TransitoryIndexUse.Write.getAlias(), newIndex.toString()));
        }
    }

    public void deleteIndex(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("About to delete index [%s] ...", name));
        }
        this.getAdminClient().indices().prepareDelete(new String[]{name}).get();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Index [%s] deleted", name));
        }
    }

    public OttcElasticSearchIndexing getElasticSearchIndexing() {
        if (this.elasticSearchIndexing == null) {
            this.setElasticSearchIndexing((OttcElasticSearchIndexing)Framework.getService(ElasticSearchIndexing.class));
        }
        return this.elasticSearchIndexing;
    }

    private void setElasticSearchIndexing(OttcElasticSearchIndexing elasticSearchIndexing) {
        this.elasticSearchIndexing = elasticSearchIndexing;
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public IndexNAliasManager adminClient(Client esClient) {
        this.adminClient = esClient.admin();
        return IndexNAliasManager.get();
    }
}

