/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.runner;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.client.IndicesAdminClient;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.EsState;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.EsStateChecker;
import org.opentoutatice.elasticsearch.core.reindexing.docs.index.IndexName;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.IndexNAliasManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.ReIndexingRunnerManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.exception.ReIndexingException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.exception.RecoveringReIndexingException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.runner.step.ReIndexingRunnerStep;

public class ReIndexingErrorsHandler {
    private static final Log log = LogFactory.getLog(ReIndexingErrorsHandler.class);
    private static ReIndexingErrorsHandler instance;

    private ReIndexingErrorsHandler() {
    }

    public static synchronized ReIndexingErrorsHandler get() {
        if (instance == null) {
            instance = new ReIndexingErrorsHandler();
        }
        return instance;
    }

    public void restoreInitialEsState(String workId, ReIndexingRunnerStep indexingStep, EsState initialEsState, Object ... params) throws RecoveringReIndexingException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"[Es State RECOVERY] About to restore initial Es State...");
            }
            switch (indexingStep) {
                case initialization: {
                    if (Framework.isTestModeSet()) {
                        this.mayFireExceptionInTestMode(ReIndexingRunnerStep.initialization);
                    }
                    this.restoreInitialEsState(initialEsState, (IndexName)params[0], (IndexName)params[1]);
                    if (!IndexNAliasManager.get().indexExists(((IndexName)params[1]).toString()).booleanValue()) break;
                    IndexNAliasManager.get().deleteIndex(((IndexName)params[1]).toString());
                    break;
                }
                case indexing: {
                    ReIndexingRunnerManager.get().setNewIndexFor(workId, (IndexName)params[1]);
                    if (Framework.isTestModeSet()) {
                        this.mayFireExceptionInTestMode(ReIndexingRunnerStep.indexing);
                    }
                    this.restoreInitialEsState(initialEsState, (IndexName)params[0], (IndexName)params[1]);
                    break;
                }
                case switching: {
                    ReIndexingRunnerManager.get().setNewIndexFor(workId, (IndexName)params[1]);
                    if (Framework.isTestModeSet()) {
                        this.mayFireExceptionInTestMode(ReIndexingRunnerStep.switching);
                    }
                    this.restoreInitialEsState(initialEsState, (IndexName)params[0], (IndexName)params[1]);
                    break;
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"[Es State RECOVERY] Initial Es State restored");
            }
        }
        catch (Exception e) {
            throw new RecoveringReIndexingException("[Es State Recovery FAILED]: ", e);
        }
    }

    protected void restoreInitialEsState(EsState initialEsState, IndexName initialIndex, IndexName newIndex) throws ReIndexingException, InterruptedException, ExecutionException {
        if (IndexNAliasManager.get().transientAliasesExist().booleanValue()) {
            IndexNAliasManager.get().deleteTransientAliases(initialIndex, newIndex);
        }
        Map<String, List<String>> currentAliases = EsStateChecker.get().getEsState().getAliases();
        Map<String, List<String>> initialAliases = initialEsState.getAliases();
        Validate.isTrue((boolean)(initialAliases.keySet() != null ? initialAliases.keySet().size() >= 1 : false));
        IndicesAdminClient esClient = IndexNAliasManager.get().getAdminClient().indices();
        for (Map.Entry<String, List<String>> currentAlias : currentAliases.entrySet()) {
            String currentAliasName = currentAlias.getKey();
            Validate.isTrue((boolean)StringUtils.endsWith((String)currentAliasName, (String)"-alias"));
            List<String> currentIndicesOfAlias = IndexNAliasManager.get().getIndicesOfAlias(currentAliasName);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Removing alias [%s] on indices: [%s]", currentAliasName, this.listToString(currentIndicesOfAlias)));
            }
            String[] currentIndices = new String[currentIndicesOfAlias.size()];
            currentIndices = currentIndicesOfAlias.toArray(currentIndices);
            esClient.prepareAliases().removeAlias(currentIndices, new String[]{currentAliasName}).get();
        }
        for (Map.Entry<String, List<String>> initialAlias : initialAliases.entrySet()) {
            String initialAliasName = initialAlias.getKey();
            Validate.isTrue((boolean)StringUtils.endsWith((String)initialAliasName, (String)"-alias"));
            List<String> initialIndicesOfAlias = initialAlias.getValue();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Restoring initial alias [%s] on indices: [%s]", initialAliasName, this.listToString(initialIndicesOfAlias)));
            }
            String[] initialIndices = new String[initialAlias.getValue().size()];
            initialIndices = initialAlias.getValue().toArray(initialIndices);
            esClient.prepareAliases().addAlias(initialIndices, initialAliasName).get();
        }
    }

    private void mayFireExceptionInTestMode(ReIndexingRunnerStep step) throws Exception {
        if (StringUtils.equals((String)step.name(), (String)Framework.getProperty((String)"ottc.reindexing.test.mode.fire.errors.step")) && StringUtils.equals((String)step.name(), (String)Framework.getProperty((String)"ottc.reindexing.test.mode.fire.errors.step.recovery"))) {
            throw new Exception(String.format("[RECOVERY ERROR TEST] during: %s", step.name()));
        }
    }

    protected String listToString(List<String> list) {
        StringBuffer sb = new StringBuffer();
        if (list != null) {
            Iterator<String> listIt = list.iterator();
            while (listIt.hasNext()) {
                String elem = listIt.next();
                sb.append(elem);
                if (!listIt.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }
}

