/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocument;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentLive;
import org.nuxeo.runtime.api.Framework;

public class SQLDocumentProxy
implements SQLDocument {
    private final Document proxy;
    private Document target;

    protected SQLDocumentProxy(Document proxy, Document target) throws DocumentException {
        this.proxy = proxy;
        this.target = target;
    }

    protected String getSchema(String xpath) throws DocumentException {
        int p = xpath.indexOf(58);
        if (p == -1) {
            throw new DocumentException("Schema not specified: " + xpath);
        }
        String prefix = xpath.substring(0, p);
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = schemaManager.getSchemaFromPrefix(prefix);
        if (schema == null && (schema = schemaManager.getSchema(prefix)) == null) {
            throw new DocumentException("No schema for prefix: " + xpath);
        }
        return schema.getName();
    }

    protected boolean isSchemaForProxy(String schema) {
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        return schemaManager.isProxySchema(schema, this.getType().getName());
    }

    protected boolean isPropertyForProxy(String xpath) throws DocumentException {
        if ("ecm:minorVersion".equals(xpath) || "ecm:majorVersion".equals(xpath)) {
            return false;
        }
        return this.isSchemaForProxy(this.getSchema(xpath));
    }

    @Override
    public Node getNode() {
        return ((SQLDocument)this.proxy).getNode();
    }

    public boolean isProxy() {
        return true;
    }

    public String getUUID() {
        return this.proxy.getUUID();
    }

    public String getName() {
        return this.proxy.getName();
    }

    public Long getPos() {
        return this.proxy.getPos();
    }

    public Document getParent() throws DocumentException {
        return this.proxy.getParent();
    }

    public String getPath() throws DocumentException {
        return this.proxy.getPath();
    }

    public void remove() throws DocumentException {
        this.proxy.remove();
    }

    public DocumentType getType() {
        return this.target.getType();
    }

    public String getRepositoryName() {
        return this.target.getRepositoryName();
    }

    public Session getSession() {
        return this.target.getSession();
    }

    public boolean isFolder() {
        return this.target.isFolder();
    }

    public void setReadOnly(boolean readonly) {
        this.target.setReadOnly(readonly);
    }

    public boolean isReadOnly() {
        return this.target.isReadOnly();
    }

    public void readDocumentPart(DocumentPart dp) throws PropertyException {
        if (this.isSchemaForProxy(dp.getName())) {
            this.proxy.readDocumentPart(dp);
        } else {
            this.target.readDocumentPart(dp);
        }
    }

    public Map<String, Serializable> readPrefetch(ComplexType complexType, Set<String> xpaths) throws PropertyException {
        if (this.isSchemaForProxy(complexType.getName())) {
            return this.proxy.readPrefetch(complexType, xpaths);
        }
        return this.target.readPrefetch(complexType, xpaths);
    }

    public void writeDocumentPart(DocumentPart dp) throws PropertyException {
        if (this.isSchemaForProxy(dp.getName())) {
            this.proxy.writeDocumentPart(dp);
        } else {
            this.target.writeDocumentPart(dp);
        }
    }

    public void setSystemProp(String name, Serializable value) throws DocumentException {
        this.target.setSystemProp(name, value);
    }

    public <T extends Serializable> T getSystemProp(String name, Class<T> type) throws DocumentException {
        return (T)this.target.getSystemProp(name, type);
    }

    public Set<String> getAllFacets() {
        return this.target.getAllFacets();
    }

    public String[] getFacets() {
        return this.target.getFacets();
    }

    public boolean hasFacet(String facet) {
        return this.target.hasFacet(facet);
    }

    public boolean addFacet(String facet) throws DocumentException {
        return this.target.addFacet(facet);
    }

    public boolean removeFacet(String facet) throws DocumentException {
        return this.target.removeFacet(facet);
    }

    public String getLifeCyclePolicy() throws LifeCycleException {
        return this.target.getLifeCyclePolicy();
    }

    public void setLifeCyclePolicy(String policy) throws LifeCycleException {
        this.target.setLifeCyclePolicy(policy);
    }

    public String getLifeCycleState() throws LifeCycleException {
        return this.target.getLifeCycleState();
    }

    public void setCurrentLifeCycleState(String state) throws LifeCycleException {
        this.target.setCurrentLifeCycleState(state);
    }

    public void followTransition(String transition) throws LifeCycleException {
        this.target.followTransition(transition);
    }

    public Collection<String> getAllowedStateTransitions() throws LifeCycleException {
        return this.target.getAllowedStateTransitions();
    }

    public Lock getLock() throws DocumentException {
        return this.target.getLock();
    }

    public Lock setLock(Lock lock) throws DocumentException {
        return this.target.setLock(lock);
    }

    public Lock removeLock(String owner) throws DocumentException {
        return this.target.removeLock(owner);
    }

    public boolean isVersion() {
        return false;
    }

    public Document getBaseVersion() throws DocumentException {
        return this.target.getBaseVersion();
    }

    public String getVersionSeriesId() throws DocumentException {
        return this.target.getVersionSeriesId();
    }

    public Document getSourceDocument() throws DocumentException {
        return this.target;
    }

    public Document checkIn(String label, String checkinComment) throws DocumentException {
        return this.target.checkIn(label, checkinComment);
    }

    public void checkOut() throws DocumentException {
        this.target.checkOut();
    }

    public boolean isCheckedOut() throws DocumentException {
        return this.target.isCheckedOut();
    }

    public boolean isLatestVersion() throws DocumentException {
        return this.target.isLatestVersion();
    }

    public boolean isMajorVersion() throws DocumentException {
        return this.target.isMajorVersion();
    }

    public boolean isLatestMajorVersion() throws DocumentException {
        return this.target.isLatestMajorVersion();
    }

    public boolean isVersionSeriesCheckedOut() throws DocumentException {
        return this.target.isVersionSeriesCheckedOut();
    }

    public String getVersionLabel() throws DocumentException {
        return this.target.getVersionLabel();
    }

    public String getCheckinComment() throws DocumentException {
        return this.target.getCheckinComment();
    }

    public Document getWorkingCopy() throws DocumentException {
        return this.target.getWorkingCopy();
    }

    public Calendar getVersionCreationDate() throws DocumentException {
        return this.target.getVersionCreationDate();
    }

    public void restore(Document version) throws DocumentException {
        this.target.restore(version);
    }

    public List<String> getVersionsIds() throws DocumentException {
        return this.target.getVersionsIds();
    }

    public Document getVersion(String label) throws DocumentException {
        return this.target.getVersion(label);
    }

    public List<Document> getVersions() throws DocumentException {
        return this.target.getVersions();
    }

    public Document getLastVersion() throws DocumentException {
        return this.target.getLastVersion();
    }

    public Document getChild(String name) throws DocumentException {
        return this.proxy.getChild(name);
    }

    public Iterator<Document> getChildren() throws DocumentException {
        return this.proxy.getChildren();
    }

    public List<String> getChildrenIds() throws DocumentException {
        return this.proxy.getChildrenIds();
    }

    public boolean hasChild(String name) throws DocumentException {
        return this.proxy.hasChild(name);
    }

    public boolean hasChildren() throws DocumentException {
        return this.proxy.hasChildren();
    }

    public Document addChild(String name, String typeName) throws DocumentException {
        return this.proxy.addChild(name, typeName);
    }

    public void orderBefore(String src, String dest) throws DocumentException {
        this.proxy.orderBefore(src, dest);
    }

    public Document getTargetDocument() {
        return this.target;
    }

    public void setTargetDocument(Document target) throws DocumentException {
        if (((SQLDocumentLive)this.proxy).isReadOnly()) {
            throw new DocumentException("Cannot write proxy: " + this);
        }
        if (!target.getVersionSeriesId().equals(this.getVersionSeriesId())) {
            throw new DocumentException("Cannot set proxy target to different version series");
        }
        this.getSession().setProxyTarget(this.proxy, target);
        this.target = target;
    }

    public Serializable getPropertyValue(String name) throws DocumentException {
        if (this.isPropertyForProxy(name)) {
            return this.proxy.getPropertyValue(name);
        }
        return this.target.getPropertyValue(name);
    }

    public void setPropertyValue(String name, Serializable value) throws DocumentException {
        if (this.isPropertyForProxy(name)) {
            this.proxy.setPropertyValue(name, value);
        } else {
            this.target.setPropertyValue(name, value);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.target + ',' + this.proxy.getUUID() + ')';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SQLDocumentProxy) {
            return this.equals((SQLDocumentProxy)other);
        }
        return false;
    }

    private boolean equals(SQLDocumentProxy other) {
        return this.proxy.equals(other.proxy) && this.target.equals(other.target);
    }

    public int hashCode() {
        return this.proxy.hashCode() + this.target.hashCode();
    }
}

