/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IReadableResourceProvider;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.string.ToStringGenerator;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class URLResourceProvider
implements IReadableResourceProvider {
    @Override
    public boolean supportsReading(@Nullable String string) {
        return URLResource.isExplicitURLResource(string);
    }

    @Override
    public IReadableResource getReadableResource(@Nonnull String string) {
        ValueEnforcer.notNull(string, "URL");
        try {
            return new URLResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Passed name '" + string + "' is not an URL!", malformedURLException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof URLResourceProvider;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }
}

