/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.simple;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.simple.ITreeItem;
import com.phloc.commons.tree.simple.ITreeItemFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeItem<DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>>
implements ITreeItem<DATATYPE, ITEMTYPE> {
    private final ITreeItemFactory<DATATYPE, ITEMTYPE> m_aFactory;
    private ITEMTYPE m_aParent;
    private DATATYPE m_aData;
    private List<ITEMTYPE> m_aChildren = null;

    public BasicTreeItem(@Nonnull ITreeItemFactory<DATATYPE, ITEMTYPE> iTreeItemFactory) {
        this.m_aFactory = ValueEnforcer.notNull(iTreeItemFactory, "Factory");
        this.m_aParent = null;
        this.m_aData = null;
    }

    public BasicTreeItem(@Nonnull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "Parent");
        if (!(ITEMTYPE instanceof BasicTreeItem)) {
            throw new IllegalArgumentException("Parent is no BasicTreeItem");
        }
        if (ITEMTYPE.getFactory() == null) {
            throw new IllegalStateException("parent item has no factory");
        }
        this.m_aParent = ITEMTYPE;
        this.m_aFactory = ITEMTYPE.getFactory();
        this.m_aData = null;
    }

    @Override
    @Nonnull
    public final ITreeItemFactory<DATATYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @OverrideOnDemand
    protected boolean isValidData(DATATYPE DATATYPE) {
        return true;
    }

    @Override
    @Nullable
    public final DATATYPE getData() {
        return this.m_aData;
    }

    @Override
    public final void setData(@Nullable DATATYPE DATATYPE) {
        if (!this.isValidData(DATATYPE)) {
            throw new IllegalArgumentException("The passed data object is invalid!");
        }
        this.m_aData = DATATYPE;
    }

    @Override
    public final boolean isRootItem() {
        return this.m_aParent == null;
    }

    @Override
    @Nullable
    public final ITEMTYPE getParent() {
        return this.m_aParent;
    }

    @Override
    @Nullable
    public final DATATYPE getParentData() {
        return this.m_aParent == null ? null : (DATATYPE)this.m_aParent.getData();
    }

    @Nonnull
    private ITEMTYPE _asT(@Nonnull BasicTreeItem<DATATYPE, ITEMTYPE> basicTreeItem) {
        return (ITEMTYPE)((ITreeItem)GenericReflection.uncheckedCast(basicTreeItem));
    }

    @Override
    @Nonnull
    public final ITEMTYPE createChildItem(@Nullable DATATYPE DATATYPE) {
        ITEMTYPE ITEMTYPE = this.m_aFactory.create(this._asT(this));
        if (ITEMTYPE == null) {
            throw new IllegalStateException("null item created!");
        }
        ITEMTYPE.setData(DATATYPE);
        this.internalAddChild(ITEMTYPE);
        return ITEMTYPE;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildren != null && !this.m_aChildren.isEmpty();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final List<ITEMTYPE> getChildren() {
        return this.m_aChildren == null ? null : ContainerHelper.newList(this.m_aChildren);
    }

    @Override
    @Nullable
    public final List<DATATYPE> getAllChildDatas() {
        if (this.m_aChildren == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (ITreeItem iTreeItem : this.m_aChildren) {
            arrayList.add(iTreeItem.getData());
        }
        return arrayList;
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildAtIndex(@Nonnegative int n) {
        if (this.m_aChildren == null) {
            throw new IndexOutOfBoundsException("Tree item has no children!");
        }
        return (ITEMTYPE)((ITreeItem)this.m_aChildren.get(n));
    }

    @Override
    @Nonnegative
    public final int getChildCount() {
        return this.m_aChildren != null ? this.m_aChildren.size() : 0;
    }

    @Override
    @Nullable
    public ITEMTYPE getFirstChild() {
        return (ITEMTYPE)((ITreeItem)ContainerHelper.getFirstElement(this.m_aChildren));
    }

    @Override
    @Nullable
    public ITEMTYPE getLastChild() {
        return (ITEMTYPE)((ITreeItem)ContainerHelper.getLastElement(this.m_aChildren));
    }

    @Override
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public final boolean isSameOrChildOf(@Nonnull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "Parent");
        for (ITreeItem<DATATYPE, ITEMTYPE> iTreeItem = this; iTreeItem != null; iTreeItem = (ITreeItem)iTreeItem.getParent()) {
            if (iTreeItem != ITEMTYPE) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public final ESuccess changeParent(@Nonnull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "NewParent");
        if (this.getParent() == ITEMTYPE) {
            return ESuccess.SUCCESS;
        }
        ITEMTYPE ITEMTYPE2 = this._asT(this);
        if (ITEMTYPE.isSameOrChildOf(ITEMTYPE2)) {
            return ESuccess.FAILURE;
        }
        if (this.getParent().removeChild(ITEMTYPE2).isUnchanged()) {
            throw new IllegalStateException("Failed to remove this from parent!");
        }
        this.m_aParent = ITEMTYPE;
        return ESuccess.valueOfChange(ITEMTYPE.internalAddChild(ITEMTYPE2));
    }

    @Override
    @Nonnull
    public final EChange internalAddChild(@Nonnull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "Child");
        if (this.m_aChildren == null) {
            this.m_aChildren = new ArrayList<ITEMTYPE>();
        }
        return EChange.valueOf(this.m_aChildren.add(ITEMTYPE));
    }

    @Override
    @Nonnull
    public final EChange removeChild(@Nonnull ITEMTYPE ITEMTYPE) {
        ValueEnforcer.notNull(ITEMTYPE, "Child");
        return EChange.valueOf(this.m_aChildren != null && this.m_aChildren.remove(ITEMTYPE));
    }

    @Override
    public final void reorderChildItems(@Nonnull Comparator<? super ITEMTYPE> comparator) {
        if (this.m_aChildren != null) {
            this.m_aChildren = ContainerHelper.getSorted(this.m_aChildren, comparator);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicTreeItem)) {
            return false;
        }
        BasicTreeItem basicTreeItem = (BasicTreeItem)object;
        return EqualsUtils.equals(this.m_aData, basicTreeItem.m_aData) && EqualsUtils.equals(this.m_aChildren, basicTreeItem.m_aChildren);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aData).append(this.m_aChildren)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("data", this.m_aData).append("children", this.m_aChildren).toString();
    }
}

