/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.theme.styling.service.descriptors.Flavor;
import org.nuxeo.theme.styling.service.descriptors.FlavorPresets;
import org.nuxeo.theme.styling.service.descriptors.Logo;
import org.nuxeo.theme.styling.service.descriptors.PalettePreview;

public class FlavorRegistry
extends ContributionFragmentRegistry<Flavor> {
    protected Map<String, Flavor> themePageFlavors = new HashMap<String, Flavor>();

    public String getContributionId(Flavor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, Flavor contrib, Flavor newOrigContrib) {
        this.themePageFlavors.put(id, contrib);
    }

    public void contributionRemoved(String id, Flavor origContrib) {
        this.themePageFlavors.remove(id);
    }

    public Flavor clone(Flavor orig) {
        if (orig == null) {
            return null;
        }
        return orig.clone();
    }

    public void merge(Flavor src, Flavor dst) {
        List<FlavorPresets> newPresets;
        PalettePreview pp;
        Logo logo;
        String newLabel;
        String newExtend = src.getExtendsFlavor();
        if (newExtend != null) {
            dst.setExtendsFlavor(newExtend);
        }
        if ((newLabel = src.getLabel()) != null) {
            dst.setLabel(newLabel);
        }
        if ((logo = src.getLogo()) != null) {
            Logo newLogo = dst.getLogo();
            if (newLogo == null) {
                newLogo = logo.clone();
            } else {
                if (logo.getHeight() != null) {
                    newLogo.setHeight(logo.getHeight());
                }
                if (logo.getWidth() != null) {
                    newLogo.setWidth(logo.getWidth());
                }
                if (logo.getTitle() != null) {
                    newLogo.setTitle(logo.getTitle());
                }
                if (logo.getPath() != null) {
                    newLogo.setPath(logo.getPath());
                }
            }
            dst.setLogo(newLogo);
        }
        if ((pp = src.getPalettePreview()) != null) {
            dst.setPalettePreview(pp);
        }
        if ((newPresets = src.getPresets()) != null) {
            List<FlavorPresets> oldPresets;
            boolean keepOld;
            ArrayList<FlavorPresets> merged = new ArrayList<FlavorPresets>();
            merged.addAll(newPresets);
            boolean bl = keepOld = src.getAppendPresets() || newPresets.isEmpty() && !src.getAppendPresets();
            if (keepOld && (oldPresets = dst.getPresets()) != null) {
                merged.addAll(0, oldPresets);
            }
            dst.setPresets(merged);
        }
    }

    public Flavor getFlavor(String id) {
        return this.themePageFlavors.get(id);
    }

    public List<Flavor> getFlavorsExtending(String flavor) {
        ArrayList<Flavor> res = new ArrayList<Flavor>();
        for (Flavor f : this.themePageFlavors.values()) {
            String extendsFlavor;
            if (f == null || StringUtils.isBlank((String)(extendsFlavor = f.getExtendsFlavor())) || !extendsFlavor.equals(flavor)) continue;
            res.add(f);
        }
        return res;
    }
}

