/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.components.ToutaticeServiceProvider;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.runtime.api.Framework;

public abstract class ToutaticeSilentProcessRunnerHelper
extends UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(ToutaticeSilentProcessRunnerHelper.class);
    public static final List<Class<?>> DEFAULT_FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
        }
    };

    public ToutaticeSilentProcessRunnerHelper(CoreSession session) {
        super(session);
    }

    public ToutaticeSilentProcessRunnerHelper(String repositoryName) {
        super(repositoryName);
    }

    protected ToutaticeSilentProcessRunnerHelper(String repositoryName, String originatingUser) {
        super(repositoryName, originatingUser);
    }

    public void silentRun(boolean runInUnrestrictedMode) throws ClientException {
        this.silentRun(runInUnrestrictedMode, DEFAULT_FILTERED_SERVICES_LIST);
    }

    public void silentRun(boolean runInUnrestrictedMode, List<Class<?>> filteredServices) throws ClientException {
        log.debug((Object)"D\u00e9marrage de l'ex\u00e9cution d'un processus en mode silencieux");
        if (runInUnrestrictedMode) {
            this.runUnrestricted(filteredServices);
        } else {
            this.run(filteredServices);
        }
        log.debug((Object)"Fin de l'ex\u00e9cution d'un processus en mode silencieux");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runUnrestricted(List<Class<?>> filteredServices) {
        this.isUnrestricted = true;
        try {
            LoginContext loginContext;
            if (this.sessionIsAlreadyUnrestricted) {
                this.run(filteredServices);
                return;
            }
            try {
                loginContext = Framework.loginAs((String)this.originatingUsername);
            }
            catch (LoginException e) {
                throw new ClientException((Throwable)e);
            }
            try {
                CoreSession baseSession = this.session;
                if (baseSession != null && !baseSession.isStateSharedByAllThreadSessions()) {
                    baseSession.save();
                }
                try {
                    NuxeoPrincipal principal;
                    this.session = CoreInstance.openCoreSession((String)this.repositoryName);
                    if (loginContext == null && Framework.isTestModeSet() && (principal = (NuxeoPrincipal)this.session.getPrincipal()) instanceof SystemPrincipal) {
                        principal.setOriginatingUser(this.originatingUsername);
                    }
                }
                catch (ClientException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ClientException((Throwable)e);
                }
                try {
                    this.run(filteredServices);
                    return;
                }
                finally {
                    try {
                        if (!this.session.isStateSharedByAllThreadSessions()) {
                            this.session.save();
                        }
                        this.session.close();
                    }
                    catch (Exception e) {
                        throw new ClientException((Throwable)e);
                    }
                    finally {
                        if (baseSession != null && !baseSession.isStateSharedByAllThreadSessions()) {
                            baseSession.save();
                        }
                        this.session = baseSession;
                    }
                }
            }
            finally {
                try {
                    if (loginContext != null) {
                        loginContext.logout();
                    }
                }
                catch (LoginException e) {
                    throw new ClientException((Throwable)e);
                }
            }
        }
        finally {
            this.isUnrestricted = false;
            if (Framework.isTestModeSet() && this.sessionIsAlreadyUnrestricted) {
                this.session.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(List<Class<?>> filteredServices) throws ClientException {
        String sessionId = this.session.getSessionId();
        try {
            if (filteredServices != null) {
                for (Class<?> service : filteredServices) {
                    ToutaticeServiceProvider.instance().register(service, sessionId);
                }
            } else {
                ToutaticeServiceProvider.instance().registerAll(sessionId);
            }
            this.run();
        }
        finally {
            if (null != filteredServices) {
                for (Class<?> service : filteredServices) {
                    ToutaticeServiceProvider.instance().unregister(service, sessionId);
                }
            } else {
                ToutaticeServiceProvider.instance().unregisterAll(sessionId);
            }
            log.debug((Object)"Fin de l'ex\u00e9cution d'un processus en mode silencieux");
        }
    }
}

