/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.spi.DirObjectFactory;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntryModifier;

public class PrincipalObjectFactory
implements DirObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment, Attributes attrs) throws Exception {
        if (attrs == null || attrs.get("objectClass") == null || !attrs.get("objectClass").contains("krb5KDCEntry")) {
            return null;
        }
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        modifier.setUserId((String)attrs.get("uid").get());
        modifier.setCommonName((String)attrs.get("cn").get());
        KerberosPrincipal principal = new KerberosPrincipal((String)attrs.get("krb5PrincipalName").get());
        modifier.setPrincipal(principal);
        if (attrs.get("krb5Key") != null) {
            Attribute krb5key = attrs.get("krb5Key");
            try {
                Map<EncryptionType, EncryptionKey> keyMap = modifier.reconstituteKeyMap(krb5key);
                modifier.setKeyMap(keyMap);
            }
            catch (IOException ioe) {
                throw new InvalidAttributeValueException("Account Kerberos key attribute 'krb5Key' contained an invalid value for krb5key.");
            }
        }
        modifier.setKeyVersionNumber(Integer.parseInt((String)attrs.get("krb5KeyVersionNumber").get()));
        return modifier.getEntry();
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        throw new UnsupportedOperationException("Attributes are required to add an entry.");
    }
}

