/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding.alias;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.binding.alias.AliasVariableMapper;

public class NuxeoAliasBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "nuxeoAliasBean";
    private static final Log log = LogFactory.getLog(NuxeoAliasBean.class);
    protected Map<String, AliasVariableMapper> vms;

    @PostConstruct
    @PreDestroy
    protected void init() {
        this.vms = new HashMap<String, AliasVariableMapper>();
    }

    public Map<String, AliasVariableMapper> getValues() {
        return Collections.unmodifiableMap(this.vms);
    }

    public AliasVariableMapper get(String id) {
        return this.vms.get(id);
    }

    public void add(AliasVariableMapper vm) {
        if (vm == null) {
            return;
        }
        String id = vm.getId();
        if (id == null && log.isDebugEnabled()) {
            log.debug((Object)"Adding alias variable mapper with null id");
        }
        if (this.vms.containsKey(id) && log.isTraceEnabled()) {
            log.trace((Object)String.format("Overriding alias variable mapper with id '%s'", id));
        }
        this.vms.put(id, vm);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Expose alias variable mapper with id '%s': %s", id, vm.getVariables()));
        }
    }

    public void remove(String id) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Remove alias variable mapper with id '%s' from request", id));
        }
        if (id == null) {
            log.debug((Object)"Remove alias variable mapper with null id");
        }
        this.vms.remove(id);
    }
}

