/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.wf.cleaner;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.model.impl.primitives.StringProperty;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class TtcWfCleaner {
    @Context
    protected ElasticSearchIndexing esi2;
    private static final Log log = LogFactory.getLog((String)"nuxeo.wf.cleaner");

    public int doCleanupDoneAndCanceledRouteInstances(String reprositoryName) {
        UnrestrictedTtcWfCleaner unrestrictedSessionRunner = new UnrestrictedTtcWfCleaner(reprositoryName);
        unrestrictedSessionRunner.runUnrestricted();
        return unrestrictedSessionRunner.getNumberOfCleanedUpWf();
    }

    private final class UnrestrictedTtcWfCleaner
    extends UnrestrictedSessionRunner {
        public static final String DOCUMENT_ROUTE_DONE_CANCEL = "SELECT * FROM DocumentRoute WHERE (ecm:currentLifeCycleState = 'done'  OR ecm:currentLifeCycleState = 'canceled') ORDER BY dc:created";
        private static final String TASK_RELATED = "SELECT * FROM Document WHERE ecm:mixinType = 'Task' AND nt:processId = '%s' AND ecm:isVersion = 0";
        private static final String OLD_PROC_INSTANCES = "SELECT * FROM Document WHERE ecm:primaryType = 'ProcedureInstance' AND dc:modified <= DATE '%s' ORDER BY dc:created";
        public static final String OLD_DOCUMENT_ROUTE_RUNNING = "SELECT * FROM DocumentRoute WHERE ecm:currentLifeCycleState = 'running'  AND docri:variablesFacet = 'facet-var_generic-model' AND dc:created <= DATE '%s' ORDER BY dc:created";
        private static final String PROC_RELATED = "SELECT * FROM Document WHERE ecm:primaryType = 'ProcedureInstance' AND ecm:uuid = '%s'";
        public static final String OLD_TASK_ENDED = "SELECT * FROM TaskDoc WHERE ecm:currentLifeCycleState = 'ended'  AND dc:created <= DATE '%s' ORDER BY dc:created";
        protected int i;
        protected int t;
        protected int p;
        protected int iErr;
        protected int tErr;
        protected int pErr;
        private int routesLimit;
        private int proceduresLimit;

        private UnrestrictedTtcWfCleaner(String repositoryName) {
            super(repositoryName);
            this.i = 0;
            this.t = 0;
            this.p = 0;
            this.iErr = 0;
            this.tErr = 0;
            this.pErr = 0;
            this.routesLimit = Integer.parseInt(Framework.getProperty((String)"foad.nuxeo.wf.clean.routes.limit", (String)"1000"));
            this.proceduresLimit = Integer.parseInt(Framework.getProperty((String)"foad.nuxeo.wf.clean.procedures.limit", (String)"1000"));
        }

        public void run() {
            ElasticSearchService service = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
            if (service != null) {
                this.removeClosedRoutes(service);
                this.removeOpenRoutes(service);
                this.removeEndedTasks(service);
                Date referenceDate = new Date();
                Calendar c = Calendar.getInstance();
                c.setTime(referenceDate);
                c.add(2, -2);
                referenceDate = c.getTime();
                SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd");
                String formattedDate = sdf.format(referenceDate);
                NxQueryBuilder queryBuilder2 = new NxQueryBuilder(this.session);
                queryBuilder2.nxql(String.format(OLD_PROC_INSTANCES, formattedDate));
                queryBuilder2.limit(this.proceduresLimit);
                DocumentModelList oldPIs = service.query(queryBuilder2);
                ArrayList<String> procids = new ArrayList<String>();
                for (DocumentModel pi : oldPIs) {
                    procids.add(pi.getId());
                }
                for (String id : procids) {
                    try {
                        this.session.removeDocument((DocumentRef)new IdRef(id));
                        ++this.p;
                    }
                    catch (ClientException e) {
                        log.error((Object)("Failed to remove procedure " + id));
                        ++this.pErr;
                        this.unrefElasticsearchDoc(id);
                    }
                }
            } else {
                throw new ClientException("TtcWfCleaner requires ElasticsearchService");
            }
            log.info((Object)("Remove " + this.p + " procedure(s). Unlink " + this.pErr + " procedure(s) on ES "));
        }

        private void removeOpenRoutes(ElasticSearchService service) {
            Date referenceDate = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(referenceDate);
            c.add(2, -2);
            referenceDate = c.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd");
            String formattedDate = sdf.format(referenceDate);
            NxQueryBuilder queryBuilder = new NxQueryBuilder(this.session);
            queryBuilder.nxql(String.format(OLD_DOCUMENT_ROUTE_RUNNING, formattedDate));
            queryBuilder.limit(this.routesLimit);
            DocumentModelList results = service.query(queryBuilder);
            ArrayList<String> routeIds = new ArrayList<String>();
            for (DocumentModel result : results) {
                Collection participatingDocuments = (Collection)result.getProperty("docri:participatingDocuments");
                for (StringProperty participatingDocument : participatingDocuments) {
                    log.info((Object)("Check participant " + participatingDocument.getValue()));
                    queryBuilder.nxql(String.format(PROC_RELATED, participatingDocument.getValue()));
                    DocumentModelList pis = service.query(queryBuilder);
                    if (pis.size() == 0) {
                        routeIds.add(result.getId());
                        continue;
                    }
                    log.info((Object)("Skip route " + result.getId() + ". A procedure is linked : " + ((DocumentModel)pis.get(0)).getId()));
                }
            }
            for (String routeDocId : routeIds) {
                queryBuilder.nxql(String.format(TASK_RELATED, routeDocId));
                DocumentModelList tasks = service.query(queryBuilder);
                this.t = 0;
                for (DocumentModel task : tasks) {
                    try {
                        this.session.removeDocument((DocumentRef)new IdRef(task.getId()));
                        ++this.t;
                    }
                    catch (ClientException e) {
                        log.error((Object)("Failed to remove task " + task.getId()));
                        ++this.tErr;
                        this.unrefElasticsearchDoc(task.getId());
                    }
                }
                if (this.t > 0) {
                    log.info((Object)("Remove " + this.t + " opened task(s). Unlink " + this.tErr + " task(s) on ES "));
                }
                try {
                    this.session.removeDocument((DocumentRef)new IdRef(routeDocId));
                    ++this.i;
                }
                catch (ClientException e) {
                    log.error((Object)("Failed to remove documentroute " + routeDocId));
                    ++this.iErr;
                    this.unrefElasticsearchDoc(routeDocId);
                }
            }
            log.info((Object)("Remove " + this.i + " opened route(s). Unlink " + this.iErr + " route(s) on ES "));
        }

        private void removeClosedRoutes(ElasticSearchService service) {
            NxQueryBuilder queryBuilder = new NxQueryBuilder(this.session);
            queryBuilder.nxql(DOCUMENT_ROUTE_DONE_CANCEL);
            queryBuilder.limit(this.routesLimit);
            DocumentModelList results = service.query(queryBuilder);
            ArrayList<String> routeIds = new ArrayList<String>();
            for (DocumentModel result : results) {
                routeIds.add(result.getId());
            }
            for (String routeDocId : routeIds) {
                queryBuilder.nxql(String.format(TASK_RELATED, routeDocId));
                DocumentModelList tasks = service.query(queryBuilder);
                this.t = 0;
                for (DocumentModel task : tasks) {
                    try {
                        this.session.removeDocument((DocumentRef)new IdRef(task.getId()));
                        ++this.t;
                    }
                    catch (ClientException e) {
                        log.error((Object)("Failed to remove task " + task.getId()));
                        ++this.tErr;
                        this.unrefElasticsearchDoc(task.getId());
                    }
                }
                if (this.t > 0) {
                    log.info((Object)("Remove " + this.t + " closed task(s). Unlink " + this.tErr + " task(s) on ES "));
                }
                try {
                    this.session.removeDocument((DocumentRef)new IdRef(routeDocId));
                    ++this.i;
                }
                catch (ClientException e) {
                    log.error((Object)("Failed to remove documentroute " + routeDocId));
                    ++this.iErr;
                    this.unrefElasticsearchDoc(routeDocId);
                }
            }
            log.info((Object)("Remove " + this.i + " closed or cancelled route(s). Unlink " + this.iErr + " route(s) on ES "));
        }

        public int getNumberOfCleanedUpWf() {
            return this.i;
        }

        private void removeEndedTasks(ElasticSearchService service) {
            Date referenceDate = new Date();
            Calendar c = Calendar.getInstance();
            c.setTime(referenceDate);
            c.add(2, -2);
            referenceDate = c.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd");
            String formattedDate = sdf.format(referenceDate);
            NxQueryBuilder queryBuilder = new NxQueryBuilder(this.session);
            queryBuilder.nxql(String.format(OLD_TASK_ENDED, formattedDate));
            queryBuilder.limit(this.routesLimit);
            DocumentModelList results = service.query(queryBuilder);
            ArrayList<String> taskProcessIds = new ArrayList<String>();
            for (DocumentModel result : results) {
                StringProperty targetDocumentId = (StringProperty)result.getProperty("nt:targetDocumentId");
                StringProperty processId = (StringProperty)result.getProperty("nt:processId");
                log.info((Object)("Check target document " + targetDocumentId.getValue()));
                queryBuilder.nxql(String.format(PROC_RELATED, targetDocumentId.getValue()));
                DocumentModelList pis = service.query(queryBuilder);
                if (pis.size() == 0) {
                    taskProcessIds.add(processId.getValue().toString());
                    continue;
                }
                log.info((Object)("Skip task " + result.getId() + ". A procedure is linked : " + ((DocumentModel)pis.get(0)).getId()));
            }
            for (String taskProcessId : taskProcessIds) {
                DocumentModelList tasks = this.session.query("SELECT * from TaskDoc where nt:processId = '" + taskProcessId + "' AND ecm:isVersion = 0");
                for (DocumentModel task : tasks) {
                    try {
                        this.session.removeDocument((DocumentRef)new IdRef(task.getId()));
                        ++this.t;
                    }
                    catch (ClientException e) {
                        log.error((Object)("Failed to remove task " + task.getId()));
                        ++this.tErr;
                    }
                }
            }
            log.info((Object)("Remove " + this.t + " ended task(s). Unlink " + this.tErr + " task(s) on ES "));
        }

        private void unrefElasticsearchDoc(String rootID) {
            AutomationService automation = (AutomationService)Framework.getService(AutomationService.class);
            OperationContext ctx = new OperationContext(this.session);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("type", "ROOT");
            parameters.put("repositoryName", "default");
            parameters.put("rootID", rootID);
            try {
                ToutaticeDocumentHelper.callOperation((AutomationService)automation, (OperationContext)ctx, (String)"Document.ReIndexES", parameters);
            }
            catch (Exception e) {
                log.error((Object)("Failed to document on ES " + rootID));
            }
        }
    }
}

