/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting;

import com.sun.faces.scripting.groovy.GroovyHelper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

class WeldAwareGroovySupportFilter
implements Filter {
    private boolean helperChecked;
    private GroovyHelper helper;
    private ServletContext sc;
    private Class containerClass;
    private Field instanceField;
    private Method instanceMethod;
    private Class singletonClass;
    private Method singletonSetMethod;

    WeldAwareGroovySupportFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.sc = filterConfig.getServletContext();
        try {
            this.obtainReflectionReferences();
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private void obtainReflectionReferences() throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        this.containerClass = tccl.loadClass("org.jboss.weld.Container");
        this.instanceField = this.containerClass.getDeclaredField("instance");
        this.instanceField.setAccessible(true);
        Class[] paramTypes = new Class[]{};
        this.instanceMethod = this.containerClass.getDeclaredMethod("instance", paramTypes);
        this.instanceMethod.setAccessible(true);
        this.singletonClass = tccl.loadClass("org.jboss.weld.bootstrap.api.Singleton");
        paramTypes = new Class[]{Object.class};
        this.singletonSetMethod = this.singletonClass.getDeclaredMethod("set", paramTypes);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.helperChecked) {
            this.helper = GroovyHelper.getCurrentInstance(this.sc);
            this.helperChecked = true;
        }
        if (this.helper != null) {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            this.helper.setClassLoader();
            ClassLoader mojarraGroovyClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(contextClassLoader);
            Object c = null;
            try {
                c = this.getWeldContainerInstance();
            }
            catch (Exception ex) {
                Logger.getLogger(WeldAwareGroovySupportFilter.class.getName()).log(Level.SEVERE, null, ex);
            }
            currentThread.setContextClassLoader(mojarraGroovyClassLoader);
            try {
                this.installMojarraGroovyClassLoaderToContainer(c);
            }
            catch (Exception ex) {
                Logger.getLogger(WeldAwareGroovySupportFilter.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.helper.setClassLoader();
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private Object getWeldContainerInstance() throws Exception {
        Object[] args = new Object[]{};
        Object result = this.instanceMethod.invoke(null, args);
        return result;
    }

    private void installMojarraGroovyClassLoaderToContainer(Object c) throws NoSuchFieldException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object aclSingletonProvider = this.instanceField.get(null);
        this.singletonSetMethod.invoke(aclSingletonProvider, c);
    }

    public void destroy() {
    }
}

