/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;
import org.sat4j.tools.xplain.DeletionStrategy;
import org.sat4j.tools.xplain.Explainer;
import org.sat4j.tools.xplain.MinimizationStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xplain<T extends ISolver>
extends SolverDecorator<T>
implements Explainer {
    protected Map<Integer, IConstr> constrs = new HashMap<Integer, IConstr>();
    protected IVecInt assump;
    private int lastCreatedVar;
    private boolean pooledVarId = false;
    private final IVecInt lastClause = new VecInt();
    private IConstr lastConstr;
    private final boolean skipDuplicatedEntries;
    private MinimizationStrategy xplainStrategy = new DeletionStrategy();
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.xplain.Xplain");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Xplain(T solver, boolean skipDuplicatedEntries) {
        super(solver);
        this.skipDuplicatedEntries = skipDuplicatedEntries;
    }

    public Xplain(T solver) {
        this(solver, true);
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        if (this.skipDuplicatedEntries) {
            if (literals.equals(this.lastClause)) {
                return null;
            }
            this.lastClause.clear();
            literals.copyTo(this.lastClause);
        }
        int newvar = this.createNewVar(literals);
        literals.push(newvar);
        this.lastConstr = super.addClause(literals);
        if (this.lastConstr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(new Integer(newvar), this.lastConstr);
        }
        return this.lastConstr;
    }

    protected int createNewVar(IVecInt literals) {
        if (this.pooledVarId) {
            this.pooledVarId = false;
            return this.lastCreatedVar;
        }
        this.lastCreatedVar = this.nextFreeVarId(true);
        return this.lastCreatedVar;
    }

    protected void discardLastestVar() {
        this.pooledVarId = true;
    }

    @Override
    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        throw new UnsupportedOperationException("Explanation requires Pseudo Boolean support. See XplainPB class instead.");
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        throw new UnsupportedOperationException("Explanation requires Pseudo Boolean support. See XplainPB class instead.");
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        throw new UnsupportedOperationException("Explanation requires Pseudo Boolean support. See XplainPB class instead.");
    }

    private IVecInt explanationKeys() throws TimeoutException {
        if (!$assertionsDisabled && this.isSatisfiable(this.assump)) {
            throw new AssertionError();
        }
        Object solver = this.decorated();
        if (solver instanceof SolverDecorator) {
            solver = ((SolverDecorator)solver).decorated();
        }
        return this.xplainStrategy.explain((ISolver)solver, this.constrs, this.assump);
    }

    @Override
    public int[] minimalExplanation() throws TimeoutException {
        IVecInt keys = this.explanationKeys();
        keys.sort();
        ArrayList<Integer> allKeys = new ArrayList<Integer>(this.constrs.keySet());
        Collections.sort(allKeys);
        int[] model = new int[keys.size()];
        int i = 0;
        IteratorInt it = keys.iterator();
        while (it.hasNext()) {
            model[i++] = allKeys.indexOf(new Integer(it.next())) + 1;
        }
        return model;
    }

    public Collection<IConstr> explain() throws TimeoutException {
        IVecInt keys = this.explanationKeys();
        ArrayList<IConstr> explanation = new ArrayList<IConstr>(keys.size());
        IteratorInt it = keys.iterator();
        while (it.hasNext()) {
            explanation.add(this.constrs.get(new Integer(it.next())));
        }
        return explanation;
    }

    public void cancelExplanation() {
        this.xplainStrategy.cancelExplanationComputation();
    }

    public Collection<IConstr> getConstraints() {
        return this.constrs.values();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt extraVariables = new VecInt();
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.findModel(extraVariables);
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        this.assump = assumps;
        VecInt extraVariables = new VecInt();
        assumps.copyTo(extraVariables);
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.findModel(extraVariables);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt extraVariables = new VecInt();
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.isSatisfiable(extraVariables);
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt extraVariables = new VecInt();
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.isSatisfiable(extraVariables, global);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        this.assump = assumps;
        VecInt extraVariables = new VecInt();
        assumps.copyTo(extraVariables);
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.isSatisfiable(extraVariables);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        this.assump = assumps;
        VecInt extraVariables = new VecInt();
        assumps.copyTo(extraVariables);
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.isSatisfiable(extraVariables, global);
    }

    @Override
    public int[] model() {
        int[] fullmodel = super.modelWithInternalVariables();
        if (fullmodel == null) {
            return null;
        }
        int[] model = new int[fullmodel.length - this.constrs.size()];
        int j = 0;
        int i = 0;
        while (i < fullmodel.length) {
            if (this.constrs.get(new Integer(Math.abs(fullmodel[i]))) == null) {
                model[j++] = fullmodel[i];
            }
            ++i;
        }
        return model;
    }

    @Override
    public String toString(String prefix) {
        System.out.println(new StringBuffer(String.valueOf(prefix)).append("Explanation (MUS) enabled solver").toString());
        System.out.println(new StringBuffer(String.valueOf(prefix)).append(this.xplainStrategy).toString());
        return super.toString(prefix);
    }

    @Override
    public void setMinimizationStrategy(MinimizationStrategy strategy) {
        this.xplainStrategy = strategy;
    }

    @Override
    public boolean removeConstr(IConstr c) {
        if (this.lastConstr == c) {
            this.lastClause.clear();
            this.lastConstr = null;
        }
        return super.removeConstr(c);
    }

    @Override
    public boolean removeSubsumedConstr(IConstr c) {
        if (this.lastConstr == c) {
            this.lastClause.clear();
            this.lastConstr = null;
        }
        return super.removeSubsumedConstr(c);
    }
}

