/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import fr.toutatice.ecm.platform.core.listener.ToutaticeDocumentEventListenerHelper;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.dublincore.NXDublinCore;
import org.nuxeo.ecm.platform.dublincore.service.DublinCoreStorageService;

public class ToutaticeChangeCreationPropertiesListener
implements EventListener {
    private static DublinCoreStorageService dcService;

    public static DublinCoreStorageService getDublinCoreStorageService() {
        if (dcService == null) {
            dcService = NXDublinCore.getDublinCoreStorageService();
        }
        return dcService;
    }

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docCtx;
        DocumentModel srcDoc;
        if ("documentCreatedByCopy".equals(event.getName()) && event.getContext() instanceof DocumentEventContext && ToutaticeDocumentEventListenerHelper.isAlterableDocument(srcDoc = (docCtx = (DocumentEventContext)event.getContext()).getSourceDocument()) && !ToutaticeChangeCreationPropertiesListener.block(docCtx)) {
            ToutaticeChangeCreationPropertiesListener.changeCreationProperties(event, docCtx, srcDoc);
        }
    }

    public static DocumentModel changeCreationProperties(Event event, DocumentEventContext docCtx, DocumentModel srcDoc) {
        Date eventDate = new Date(event.getTime());
        Calendar cEventDate = Calendar.getInstance();
        cEventDate.setTime(eventDate);
        DublinCoreStorageService service = ToutaticeChangeCreationPropertiesListener.getDublinCoreStorageService();
        service.addContributor(srcDoc, event);
        srcDoc.setPropertyValue("dc:created", (Serializable)cEventDate);
        srcDoc.setPropertyValue("dc:modified", (Serializable)cEventDate);
        return ToutaticeChangeCreationPropertiesListener.setCreator(docCtx, srcDoc);
    }

    public static boolean block(DocumentEventContext docCtx) {
        Boolean disableDC = (Boolean)docCtx.getProperty("disableDublinCoreListener");
        return BooleanUtils.isTrue((Boolean)disableDC);
    }

    public static DocumentModel setCreator(DocumentEventContext docCtx, DocumentModel document) {
        NuxeoPrincipal principal = (NuxeoPrincipal)docCtx.getPrincipal();
        document.setProperty("dublincore", "creator", (Object)principal.getName());
        return document;
    }
}

