/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ToutaticeDocumentMoved
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext ctx = (DocumentEventContext)event.getContext();
            DocumentModel movedDocument = ctx.getSourceDocument();
            CoreSession session = ctx.getCoreSession();
            if (!movedDocument.isProxy()) {
                UnrestrictedMoveProxyRunner runner = new UnrestrictedMoveProxyRunner(session, (EventContext)ctx, movedDocument);
                runner.runUnrestricted();
            }
        }
    }

    private class UnrestrictedMoveProxyRunner
    extends UnrestrictedSessionRunner {
        private EventContext ctx;
        private DocumentModel movedDocument;

        public UnrestrictedMoveProxyRunner(CoreSession session, EventContext ctx, DocumentModel document) {
            super(session);
            this.ctx = ctx;
            this.movedDocument = document;
        }

        public void run() throws ClientException {
            DocumentModelList proxies;
            DocumentRef dstFolderRef;
            DocumentRef srcFolderRef = (DocumentRef)this.ctx.getProperty("parentPath");
            if (!srcFolderRef.equals(dstFolderRef = this.movedDocument.getParentRef()) && null != (proxies = this.session.getProxies(this.movedDocument.getRef(), srcFolderRef)) && 0 < proxies.size()) {
                for (DocumentModel proxy : proxies) {
                    this.session.move(proxy.getRef(), dstFolderRef, null);
                    this.session.save();
                    this.session.orderBefore(dstFolderRef, proxy.getName(), this.movedDocument.getName());
                }
            }
        }
    }
}

