/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.instances.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.TaskService;
import org.osivia.procedures.instances.operations.StartProcedureUnrestrictedSessionRunner;

@Operation(id="Services.StartProcedure", category="Services", label="StartProcedure", description="Starts a procedure.")
public class StartProcedure {
    public static final String ID = "Services.StartProcedure";
    @Context
    private CoreSession session;
    @Context
    private DocumentRoutingService documentRoutingService;
    @Context
    private TaskService taskService;
    @Param(name="taskTitle")
    private String taskTitle;
    @Param(name="properties", required=false)
    private Properties properties;
    @Param(name="actors", required=false)
    private StringList actors;
    @Param(name="additionalAuthorizations", required=false)
    private StringList additionalAuthorizations;

    @OperationMethod
    public DocumentModel run() throws Exception {
        return this.execute(null);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws Exception {
        BlobList blobList = new BlobList();
        blobList.add((Object)blob);
        return this.execute(blobList);
    }

    @OperationMethod
    public DocumentModel run(BlobList blobList) throws Exception {
        return this.execute(blobList);
    }

    private DocumentModel execute(BlobList blobList) throws Exception {
        String procedureInitiator = this.session.getPrincipal().getName();
        StartProcedureUnrestrictedSessionRunner unrestrictedSessionRunner = new StartProcedureUnrestrictedSessionRunner(this.session, procedureInitiator, this.taskTitle, this.properties, this.actors, this.additionalAuthorizations, blobList);
        unrestrictedSessionRunner.runUnrestricted();
        return unrestrictedSessionRunner.getProcedureInstance();
    }
}

