/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.elasticsearch.common.collect.ImmutableOpenMap;

public final class FieldNameAnalyzer
extends AnalyzerWrapper {
    private final ImmutableOpenMap<String, Analyzer> analyzers;
    private final Analyzer defaultAnalyzer;

    public FieldNameAnalyzer(ImmutableOpenMap<String, Analyzer> analyzers, Analyzer defaultAnalyzer) {
        this.analyzers = analyzers;
        this.defaultAnalyzer = defaultAnalyzer;
    }

    public ImmutableOpenMap<String, Analyzer> analyzers() {
        return this.analyzers;
    }

    public Analyzer defaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.getAnalyzer(fieldName);
    }

    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return components;
    }

    private Analyzer getAnalyzer(String name) {
        Analyzer analyzer = this.analyzers.get(name);
        if (analyzer != null) {
            return analyzer;
        }
        return this.defaultAnalyzer;
    }
}

