/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;

public class IWork2PDFConverter
implements Converter {
    public static final List<String> IWORK_MIME_TYPES = Arrays.asList("application/vnd.apple.pages", "application/vnd.apple.keynote", "application/vnd.apple.numbers", "application/vnd.apple.iwork");
    private static final String IWORK_PREVIEW_FILE = "QuickLook/Preview.pdf";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            Blob blob = blobHolder.getBlob();
            String mimeType = blob.getMimeType();
            if (mimeType == null) throw new ConversionException("not an iWork file");
            if (!IWORK_MIME_TYPES.contains(mimeType)) {
                throw new ConversionException("not an iWork file");
            }
            try (InputStream blobStream = blob.getStream();){
                if (!ZipUtils.isValid((InputStream)blobStream)) {
                    throw new ConversionException("not a valid iWork file");
                }
            }
            blobStream = blob.getStream();
            var6_7 = null;
            try {
                if (ZipUtils.hasEntry((InputStream)blobStream, (String)IWORK_PREVIEW_FILE)) {
                    FileBlob previewBlob;
                    try (InputStream previewPDFFile = ZipUtils.getEntryContentAsStream((InputStream)blob.getStream(), (String)IWORK_PREVIEW_FILE);){
                        previewBlob = new FileBlob(previewPDFFile);
                    }
                    SimpleCachableBlobHolder simpleCachableBlobHolder = new SimpleCachableBlobHolder((Blob)previewBlob);
                    return simpleCachableBlobHolder;
                }
                throw new ConversionException("iWork file does not contain a pdf preview.");
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
            finally {
                if (blobStream != null) {
                    if (var6_7 != null) {
                        try {
                            blobStream.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        blobStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ConversionException("Could not find the pdf preview in the iWork file", (Exception)e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

