/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HostAddressType
implements Comparable<HostAddressType> {
    public static final HostAddressType ADDRTYPE_IPV4 = new HostAddressType(2, "IPv4");
    public static final HostAddressType ADDRTYPE_DIRECTIONAL = new HostAddressType(3, "Directional");
    public static final HostAddressType ADDRTYPE_CHAOSNET = new HostAddressType(5, "ChaosNet");
    public static final HostAddressType ADDRTYPE_XNS = new HostAddressType(6, "XEROX Network Services (XNS)");
    public static final HostAddressType ADDRTYPE_ISO = new HostAddressType(7, "ISO");
    public static final HostAddressType ADDRTYPE_DECNET = new HostAddressType(12, "DECNET Phase IV");
    public static final HostAddressType ADDRTYPE_APPLETALK = new HostAddressType(16, "AppleTalk DDP");
    public static final HostAddressType ADDRTYPE_NETBIOS = new HostAddressType(20, "NetBios");
    public static final HostAddressType ADDRTYPE_IPV6 = new HostAddressType(24, "IPv6");
    private static final HostAddressType[] values = new HostAddressType[]{ADDRTYPE_IPV4, ADDRTYPE_DIRECTIONAL, ADDRTYPE_CHAOSNET, ADDRTYPE_XNS, ADDRTYPE_ISO, ADDRTYPE_DECNET, ADDRTYPE_APPLETALK, ADDRTYPE_NETBIOS, ADDRTYPE_IPV6};
    public static final List<HostAddressType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private HostAddressType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static HostAddressType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (HostAddressType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return ADDRTYPE_IPV4;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(HostAddressType that) {
        return this.ordinal - that.ordinal;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }
}

