/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.addons.toutapad.ecm.helpers;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;

public class ToutapadDocumentHelper {
    private static final Log log = LogFactory.getLog(ToutapadDocumentHelper.class);
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };

    private ToutapadDocumentHelper() {
    }

    public static void synchronizePad(CoreSession session, DocumentModel pad, String content) throws ClientException {
        if (null != content) {
            PadSynchronizationRunner runner = new PadSynchronizationRunner(session, pad, content);
            runner.silentRun(true, FILTERED_SERVICES_LIST);
        }
    }

    private static class PadSynchronizationRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;
        private String content;

        public PadSynchronizationRunner(CoreSession session, DocumentModel document, String content) {
            super(session);
            this.document = document;
            this.content = content;
        }

        public void run() throws ClientException {
            this.document.setPropertyValue("note:note", (Serializable)((Object)this.content));
            this.session.saveDocument(this.document);
            log.debug((Object)("Synchronized successfully the pad '(" + this.document.getId() + ") " + this.document.getTitle() + "'"));
        }
    }
}

