/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.helper;

import java.util.Map;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class TransitionHelper {
    private TransitionHelper() {
    }

    public static boolean isTransition(DocumentEventContext docCtx, Event event, String checkedTransition) {
        Map properties;
        if ("lifecycle_transition_event".equals(event.getName()) && (properties = docCtx.getProperties()) != null) {
            String transition = (String)properties.get("transition");
            return checkedTransition.equals(transition);
        }
        return false;
    }

    public static String getTransition(DocumentEventContext docCtx, Event event) {
        if (TransitionHelper.isTransition(docCtx, event, "delete")) {
            return "delete";
        }
        if (TransitionHelper.isTransition(docCtx, event, "undelete")) {
            return "undelete";
        }
        return "";
    }

    public static String getTransitionName(boolean isDeletion) {
        if (isDeletion) {
            return "delete";
        }
        return "undelete";
    }
}

