/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class TelephoneNumberSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.50";
    private List<String> regexps;
    private List<Pattern> compiledREs;
    private static final String DEFAULT_REGEXP = "^ *[+]? *((\\([0-9- ]+\\))|[0-9- ]+)+$";
    private Pattern defaultPattern = Pattern.compile("^ *[+]? *((\\([0-9- ]+\\))|[0-9- ]+)+$");
    protected boolean defaultMandatory = false;

    public TelephoneNumberSyntaxChecker() {
        super(SC_OID);
    }

    protected TelephoneNumberSyntaxChecker(String oid) {
        super(oid);
    }

    public void addRegexp(String regexp) {
        if (this.defaultMandatory) {
            return;
        }
        try {
            Pattern compiledRE = Pattern.compile(regexp);
            if (this.regexps == null) {
                this.regexps = new ArrayList<String>();
                this.compiledREs = new ArrayList<Pattern>();
            }
            this.regexps.add(regexp);
            this.compiledREs.add(compiledRE);
        }
        catch (PatternSyntaxException pse) {
            return;
        }
    }

    public void setDefaultRegexp(String regexp) {
        try {
            this.defaultPattern = Pattern.compile(regexp);
            this.defaultMandatory = true;
            this.regexps = null;
            this.compiledREs = null;
        }
        catch (PatternSyntaxException pse) {
            return;
        }
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        if (this.defaultMandatory) {
            return this.defaultPattern.matcher(strValue).matches();
        }
        if (this.defaultPattern.matcher(strValue).matches()) {
            return true;
        }
        if (this.compiledREs == null) {
            return false;
        }
        for (Pattern pattern : this.compiledREs) {
            if (!pattern.matcher(strValue).matches()) continue;
            return true;
        }
        return false;
    }
}

