/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class CommonTermsQueryParser
implements QueryParser {
    public static final String NAME = "common";
    static final float DEFAULT_MAX_TERM_DOC_FREQ = 0.01f;
    static final BooleanClause.Occur DEFAULT_HIGH_FREQ_OCCUR = BooleanClause.Occur.SHOULD;
    static final BooleanClause.Occur DEFAULT_LOW_FREQ_OCCUR = BooleanClause.Occur.SHOULD;
    static final boolean DEFAULT_DISABLE_COORDS = true;

    @Inject
    public CommonTermsQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        String field;
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[common] query malformed, no field");
        }
        String fieldName = parser.currentName();
        Object value = null;
        float boost = 1.0f;
        String queryAnalyzer = null;
        String lowFreqMinimumShouldMatch = null;
        String highFreqMinimumShouldMatch = null;
        boolean disableCoords = true;
        BooleanClause.Occur highFreqOccur = DEFAULT_HIGH_FREQ_OCCUR;
        BooleanClause.Occur lowFreqOccur = DEFAULT_LOW_FREQ_OCCUR;
        float maxTermFrequency = 0.01f;
        String queryName = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                String op;
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                        String innerFieldName = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                innerFieldName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("low_freq".equals(innerFieldName) || "lowFreq".equals(innerFieldName)) {
                                lowFreqMinimumShouldMatch = parser.text();
                                continue;
                            }
                            if ("high_freq".equals(innerFieldName) || "highFreq".equals(innerFieldName)) {
                                highFreqMinimumShouldMatch = parser.text();
                                continue;
                            }
                            throw new QueryParsingException(parseContext.index(), "[common] query does not support [" + innerFieldName + "] for [" + currentFieldName + "]");
                        }
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[common] query does not support [" + currentFieldName + "]");
                }
                if (!token.isValue()) continue;
                if ("query".equals(currentFieldName)) {
                    value = parser.objectText();
                    continue;
                }
                if ("analyzer".equals(currentFieldName)) {
                    String analyzer = parser.text();
                    if (parseContext.analysisService().analyzer(analyzer) == null) {
                        throw new QueryParsingException(parseContext.index(), "[common] analyzer [" + parser.text() + "] not found");
                    }
                    queryAnalyzer = analyzer;
                    continue;
                }
                if ("disable_coord".equals(currentFieldName) || "disableCoord".equals(currentFieldName)) {
                    disableCoords = parser.booleanValue();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("high_freq_operator".equals(currentFieldName) || "highFreqOperator".equals(currentFieldName)) {
                    op = parser.text();
                    if ("or".equalsIgnoreCase(op)) {
                        highFreqOccur = BooleanClause.Occur.SHOULD;
                        continue;
                    }
                    if ("and".equalsIgnoreCase(op)) {
                        highFreqOccur = BooleanClause.Occur.MUST;
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[common] query requires operator to be either 'and' or 'or', not [" + op + "]");
                }
                if ("low_freq_operator".equals(currentFieldName) || "lowFreqOperator".equals(currentFieldName)) {
                    op = parser.text();
                    if ("or".equalsIgnoreCase(op)) {
                        lowFreqOccur = BooleanClause.Occur.SHOULD;
                        continue;
                    }
                    if ("and".equalsIgnoreCase(op)) {
                        lowFreqOccur = BooleanClause.Occur.MUST;
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[common] query requires operator to be either 'and' or 'or', not [" + op + "]");
                }
                if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                    lowFreqMinimumShouldMatch = parser.text();
                    continue;
                }
                if ("cutoff_frequency".equals(currentFieldName)) {
                    maxTermFrequency = parser.floatValue();
                    continue;
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[common] query does not support [" + currentFieldName + "]");
            }
            parser.nextToken();
        } else {
            value = parser.objectText();
            token = parser.nextToken();
            if (token != XContentParser.Token.END_OBJECT) {
                throw new QueryParsingException(parseContext.index(), "[common] query parsed in simplified form, with direct field name, but included more options than just the field name, possibly use its 'options' form, with 'query' element?");
            }
        }
        if (value == null) {
            throw new QueryParsingException(parseContext.index(), "No text specified for text query");
        }
        FieldMapper mapper = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            mapper = smartNameFieldMappers.mapper();
            field = mapper.names().indexName();
        } else {
            field = fieldName;
        }
        Analyzer analyzer = null;
        if (queryAnalyzer == null) {
            if (mapper != null) {
                analyzer = mapper.searchAnalyzer();
            }
            if (analyzer == null && smartNameFieldMappers != null) {
                analyzer = smartNameFieldMappers.searchAnalyzer();
            }
            if (analyzer == null) {
                analyzer = parseContext.mapperService().searchAnalyzer();
            }
        } else {
            analyzer = parseContext.mapperService().analysisService().analyzer(queryAnalyzer);
            if (analyzer == null) {
                throw new ElasticsearchIllegalArgumentException("No analyzer found for [" + queryAnalyzer + "]");
            }
        }
        ExtendedCommonTermsQuery commonsQuery = new ExtendedCommonTermsQuery(highFreqOccur, lowFreqOccur, maxTermFrequency, disableCoords, mapper);
        commonsQuery.setBoost(boost);
        Query query = this.parseQueryString(commonsQuery, value.toString(), field, parseContext, analyzer, lowFreqMinimumShouldMatch, highFreqMinimumShouldMatch, smartNameFieldMappers);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Query parseQueryString(ExtendedCommonTermsQuery query, String queryString, String field, QueryParseContext parseContext, Analyzer analyzer, String lowFreqMinimumShouldMatch, String highFreqMinimumShouldMatch, MapperService.SmartNameFieldMappers smartNameFieldMappers) throws IOException {
        TokenStream source = analyzer.tokenStream(field, queryString.toString());
        int count = 0;
        try {
            source.reset();
            CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
            while (source.incrementToken()) {
                BytesRef ref = new BytesRef(termAtt.length() * 4);
                UnicodeUtil.UTF16toUTF8((char[])termAtt.buffer(), (int)0, (int)termAtt.length(), (BytesRef)ref);
                query.add(new Term(field, ref));
                ++count;
            }
        }
        finally {
            source.close();
        }
        if (count == 0) {
            return null;
        }
        query.setLowFreqMinimumNumberShouldMatch(lowFreqMinimumShouldMatch);
        query.setHighFreqMinimumNumberShouldMatch(highFreqMinimumShouldMatch);
        return QueryParsers.wrapSmartNameQuery((Query)query, smartNameFieldMappers, parseContext);
    }
}

