/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.query;

import fr.toutatice.ecm.elasticsearch.fetcher.TTCEsFetcher;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.elasticsearch.fetcher.Fetcher;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;

public class TTCNxQueryBuilder
extends NxQueryBuilder {
    private static final Log log = LogFactory.getLog(TTCNxQueryBuilder.class);
    private static final String RCD_VARIABLES_PREFIX = "rcd:globalVariablesValues.";
    private static final String DC_TITLE = "dc:title";
    private static final String LOWERCASE_SUFFIX = ".lowercase";
    private Fetcher fetcher;
    private boolean automationCall = true;
    protected CoreSession session;

    public TTCNxQueryBuilder(CoreSession coreSession) {
        super(coreSession);
        this.session = coreSession;
    }

    public Fetcher getFetcher(SearchResponse response, Map<String, String> repoNames) {
        this.fetcher = this.automationCall ? new TTCEsFetcher(this.getSession(), response, repoNames) : super.getFetcher(response, repoNames);
        return this.fetcher;
    }

    public SortBuilder[] getSortBuilders() {
        if (this.getSortInfos().isEmpty()) {
            return new SortBuilder[0];
        }
        SortBuilder[] ret = new SortBuilder[this.getSortInfos().size()];
        int i = 0;
        for (SortInfo sortInfo : this.getSortInfos()) {
            ret[i++] = new FieldSortBuilder(sortInfo.getSortColumn()).order(sortInfo.getSortAscending() ? SortOrder.ASC : SortOrder.DESC).ignoreUnmapped(true);
        }
        return ret;
    }

    public SearchResponse getSearchResponse() {
        if (this.fetcher != null) {
            return ((TTCEsFetcher)this.fetcher).getResponse();
        }
        return new SearchResponse(InternalSearchResponse.empty(), "", 0, 0, 0L, null);
    }

    public boolean isAutomationCall() {
        return this.automationCall;
    }

    public NxQueryBuilder setAutomationCall(boolean automationCall) {
        this.automationCall = automationCall;
        return this;
    }

    public boolean isFetchFromElasticsearch() {
        boolean is = true;
        if (!this.automationCall) {
            is = super.isFetchFromElasticsearch();
        }
        return is;
    }

    public QueryBuilder makeQuery() {
        QueryBuilder esQueryBuilder = super.makeQuery();
        if (esQueryBuilder != null && esQueryBuilder instanceof QueryStringQueryBuilder) {
            ((QueryStringQueryBuilder)esQueryBuilder).analyzeWildcard(true);
        }
        if (StringUtils.contains((String)this.getNxql().toLowerCase(), (String)"order by")) {
            this.adaptSortInfos(this.getNxql());
        }
        return esQueryBuilder;
    }

    private void adaptSortInfos(String nxql) {
        ListIterator listIterator = super.getSortInfos().listIterator();
        while (listIterator.hasNext()) {
            SortInfo sortInfo = (SortInfo)listIterator.next();
            String sortColumn = sortInfo.getSortColumn();
            if (!StringUtils.equalsIgnoreCase((String)DC_TITLE, (String)sortColumn) && !StringUtils.startsWith((String)sortColumn, (String)RCD_VARIABLES_PREFIX)) continue;
            sortInfo.setSortColumn(sortColumn.concat(LOWERCASE_SUFFIX));
        }
    }
}

