/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class FileVersion
implements Comparable<FileVersion> {
    protected static final String SNAPSHOT = "-SNAPSHOT";
    protected String version;
    protected boolean snapshot;
    protected boolean specialQualifier;
    protected Integer[] splitVersion;
    protected String qualifier = "";
    private String separator = "";
    private String tmpVersion;
    private static final Pattern SPECIAL_QUALIFIER = Pattern.compile("^-(((RC)|(rc)|(alpha)|(ALPHA)|(beta)|(BETA)\\d+)|([a-zA-Z][0-9]{8})).*$");

    public String getQualifier() {
        return this.qualifier;
    }

    public Integer[] getSplitVersion() {
        return this.splitVersion;
    }

    public FileVersion(String value) {
        this.version = value;
        this.snapshot = value.endsWith(SNAPSHOT);
        this.split(this.getVersionWithoutSnapshot());
        this.specialQualifier = SPECIAL_QUALIFIER.matcher(this.qualifier).matches();
    }

    public void split(String value) {
        ArrayList<Integer> versions;
        block4: {
            if (value.startsWith("r")) {
                value = value.substring(1);
            }
            versions = new ArrayList<Integer>();
            this.tmpVersion = value;
            do {
                if (!".".equals(this.separator)) continue;
                try {
                    versions.add(Integer.valueOf(this.tmpVersion));
                    break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            } while (this.splitWith(".", versions) || this.splitWith("-", versions) || this.splitWith("_", versions));
            this.qualifier = this.separator + this.tmpVersion;
        }
        this.splitVersion = versions.toArray(new Integer[0]);
    }

    private boolean splitWith(String token, List<Integer> versions) {
        try {
            int index = this.tmpVersion.indexOf(token);
            if (index > 0) {
                versions.add(Integer.valueOf(this.tmpVersion.substring(0, index)));
                this.separator = this.tmpVersion.substring(index, index + 1);
                this.tmpVersion = this.tmpVersion.substring(index + 1);
                return true;
            }
            if (versions.isEmpty()) {
                versions.add(Integer.valueOf(this.tmpVersion));
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int compareTo(FileVersion o) {
        int oNumber;
        int number;
        int result;
        if (this.snapshot && this.getVersionWithoutSnapshot().equals(o.getVersion()) || this.specialQualifier && this.getVersionWithoutQualifier().equals(o.getVersion())) {
            return -1;
        }
        if (o.isSnapshot() && this.version.equals(o.getVersionWithoutSnapshot()) || o.hasSpecialQualifier() && this.version.equals(o.getVersionWithoutQualifier())) {
            return 1;
        }
        int index = 0;
        while ((result = (number = this.splitVersion.length > index ? this.splitVersion[index] : 0) - (oNumber = o.getSplitVersion().length > index ? o.getSplitVersion()[index] : 0)) == 0 && (this.splitVersion.length > ++index || o.getSplitVersion().length > index)) {
        }
        if (result == 0) {
            result = this.qualifier.compareTo(o.getQualifier());
        }
        return result;
    }

    public boolean equals(Object o) {
        return this == o || o != null && o instanceof FileVersion && this.compareTo((FileVersion)o) == 0;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionWithoutSnapshot() {
        if (this.snapshot) {
            return this.version.substring(0, this.version.lastIndexOf(SNAPSHOT));
        }
        return this.version;
    }

    public boolean greaterThan(FileVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean lessThan(FileVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isSnapshot() {
        return this.snapshot;
    }

    public boolean hasSpecialQualifier() {
        return this.specialQualifier;
    }

    public String getVersionWithoutQualifier() {
        return this.version.substring(0, this.version.lastIndexOf(this.qualifier));
    }

    public String toString() {
        return this.version;
    }
}

