/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.es.customizer.writers.impl;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.runtime.api.Framework;

public class UserProfileWriter
extends AbstractCustomJsonESWriter {
    private LDAPSession session;

    @Override
    public boolean accept(DocumentModel doc) {
        return doc.getType().equals("UserProfile");
    }

    @Override
    public void writeData(JsonGenerator jg, DocumentModel doc, String[] schemas, Map<String, String> contextParameters) throws IOException {
        DocumentModel entry;
        String login = null;
        for (ACL acl : doc.getACP().getACLs()) {
            for (ACE ace : acl.getACEs()) {
                if (!ace.getPermission().equals("Everything") || !ace.isGranted()) continue;
                login = ace.getUsername();
            }
        }
        if (login != null && (entry = this.getLdapEntry(login)) != null) {
            Serializable mail2;
            Serializable displayname = entry.getPropertyValue("displayName");
            if (displayname != null) {
                jg.writeStringField("dc:title", displayname.toString());
            } else {
                jg.writeStringField("dc:title", login);
            }
            Serializable mail = entry.getPropertyValue("email");
            if (mail != null) {
                jg.writeStringField("ttc_userprofile:mail", mail.toString());
            }
            if ((mail2 = entry.getPropertyValue("emailaca")) != null) {
                jg.writeStringField("ttc_userprofile:mailaca", mail2.toString());
            }
            HashSet<String> workspaces = new HashSet<String>();
            List groups = (List)((Object)entry.getPropertyValue("groups"));
            for (String group : groups) {
                String[] split = group.split("_");
                workspaces.add(split[0]);
            }
            jg.writeStringField("ttc_userprofile:login", login);
            jg.writeArrayFieldStart("ttc_userprofile:workspaces");
            for (String workspace : workspaces) {
                jg.writeString(workspace);
            }
            jg.writeEndArray();
        }
    }

    private DocumentModel getLdapEntry(String login) {
        DocumentModel entry = null;
        if (this.session != null) {
            try {
                entry = this.session.getEntryFromSource(login, false);
            }
            catch (ClientException e) {
                this.session = null;
            }
        }
        if (this.session == null) {
            DirectoryService service = (DirectoryService)Framework.getService(DirectoryService.class);
            LDAPDirectory directory = (LDAPDirectory)service.getDirectory("userLdapDirectory");
            this.session = (LDAPSession)directory.getSession();
            entry = this.session.getEntryFromSource(login, false);
        }
        return entry;
    }
}

