/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.restProxies;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishingException;
import org.nuxeo.ecm.platform.publisher.api.RemotePublicationTreeManager;
import org.nuxeo.ecm.platform.publisher.remoting.invoker.DefaultRemotePublicationInvoker;
import org.nuxeo.ecm.platform.publisher.remoting.invoker.RemotePublicationInvoker;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.RemotePublisherMarshaler;

public class RemotePublicationTreeManagerRestProxy
implements RemotePublicationTreeManager {
    private static final Log log = LogFactory.getLog(RemotePublicationTreeManagerRestProxy.class);
    protected String baseURL;
    protected String userName;
    protected String password;
    protected RemotePublisherMarshaler marshaler;
    protected RemotePublicationInvoker invoker;

    public RemotePublicationTreeManagerRestProxy(String baseURL, String userName, String password, RemotePublisherMarshaler marshaler) {
        this.baseURL = baseURL;
        this.userName = userName;
        this.password = password;
        this.marshaler = marshaler;
        this.invoker = new DefaultRemotePublicationInvoker();
        this.invoker.init(baseURL, userName, password, marshaler);
    }

    public List<PublishedDocument> getChildrenDocuments(PublicationNode node) throws ClientException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(node);
        return (List)this.invoker.invoke("getChildrenDocuments", params);
    }

    public List<PublicationNode> getChildrenNodes(PublicationNode node) throws ClientException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(node);
        return (List)this.invoker.invoke("getChildrenNodes", params);
    }

    public List<PublishedDocument> getExistingPublishedDocument(String sid, DocumentLocation docLoc) throws ClientException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(sid);
        params.add(docLoc);
        return (List)this.invoker.invoke("getExistingPublishedDocument", params);
    }

    public PublicationNode getNodeByPath(String sid, String path) throws ClientException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(sid);
        params.add(path);
        return (PublicationNode)this.invoker.invoke("getNodeByPath", params);
    }

    public PublicationNode getParent(PublicationNode node) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(node);
        try {
            return (PublicationNode)this.invoker.invoke("getParent", params);
        }
        catch (ClientException e) {
            log.error((Object)"Error during parent lookup", (Throwable)e);
            return null;
        }
    }

    public List<PublishedDocument> getPublishedDocumentInNode(PublicationNode node) throws ClientException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(node);
        return (List)this.invoker.invoke("getPublishedDocumentInNode", params);
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(doc);
        params.add(targetNode);
        return (PublishedDocument)this.invoker.invoke("publish", params);
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        ArrayList<Object> cparams = new ArrayList<Object>();
        cparams.add(doc);
        cparams.add(targetNode);
        cparams.add(params);
        return (PublishedDocument)this.invoker.invoke("publish", cparams);
    }

    public void unpublish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(doc);
        params.add(targetNode);
        this.invoker.invoke("unpublish", params);
    }

    public void unpublish(String sid, PublishedDocument publishedDocument) throws ClientException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(sid);
        params.add(publishedDocument);
        this.invoker.invoke("unpublish", params);
    }

    public Map<String, String> initRemoteSession(String treeConfigName, Map<String, String> params) throws Exception {
        ArrayList<Object> cparams = new ArrayList<Object>();
        cparams.add(treeConfigName);
        cparams.add(params);
        return (Map)this.invoker.invoke("initRemoteSession", cparams);
    }

    public void setCurrentDocument(String sid, DocumentModel currentDocument) throws ClientException {
    }

    public void validatorPublishDocument(String sid, PublishedDocument publishedDocument, String comment) throws PublishingException {
        throw new UnsupportedOperationException();
    }

    public void validatorRejectPublication(String sid, PublishedDocument publishedDocument, String comment) throws PublishingException {
        throw new UnsupportedOperationException();
    }

    public boolean canPublishTo(String sid, PublicationNode publicationNode) throws ClientException {
        return publicationNode != null && publicationNode.getParent() != null;
    }

    public boolean canUnpublish(String sid, PublishedDocument publishedDocument) throws ClientException {
        return true;
    }

    public boolean canManagePublishing(String sid, PublishedDocument publishedDocument) throws ClientException {
        return true;
    }

    public boolean hasValidationTask(String sid, PublishedDocument publishedDocument) throws ClientException {
        return false;
    }

    public PublishedDocument wrapToPublishedDocument(String sid, DocumentModel documentModel) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public boolean isPublicationNode(String sid, DocumentModel documentModel) {
        throw new UnsupportedOperationException();
    }

    public PublicationNode wrapToPublicationNode(String sid, DocumentModel documentModel) throws ClientException {
        throw new UnsupportedOperationException();
    }

    public void release(String sid) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(sid);
        try {
            this.invoker.invoke("release", params);
        }
        catch (ClientException e) {
            log.error((Object)"Error during release", (Throwable)e);
        }
    }
}

