/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.bns;

import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.GetDuplicateFiles", category="Document", label="Get duplicated documents by path", description="Get documents which share the same path, perform en ES query and aggregate by count on ecm:path")
public class GetDuplicateFiles {
    public static final String ID = "Document.GetDuplicateFiles";
    @Context
    protected CoreSession session;

    @OperationMethod
    public Object run(DocumentRef docRef) throws ClientException {
        JSONObject duplicatedItems = new JSONObject();
        ElasticSearchAdmin esAdmin = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        SearchRequestBuilder request = esAdmin.getClient().prepareSearch(new String[]{esAdmin.getIndexNameForRepository(this.session.getRepositoryName())}).setTypes(new String[]{"doc"}).setSearchType(SearchType.QUERY_THEN_FETCH);
        String clause = " ecm:path startswith ";
        String NXQLClause = "select ecm:uuid from Document where ((%s '%s') AND ecm:isVersion = 0)";
        QueryBuilder queryBuilder = NxqlQueryConverter.toESQueryBuilder((String)String.format(NXQLClause, clause, docRef.toString()), (CoreSession)this.session);
        request.setQuery(queryBuilder);
        TermsBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)"top_ecm:path").field("ecm:path")).size(1000).order(Terms.Order.aggregation((String)"_count", (boolean)false));
        request.addAggregation((AbstractAggregationBuilder)aggregation);
        SearchResponse response = (SearchResponse)request.get();
        Map results = response.getAggregations().asMap();
        StringTerms topField = (StringTerms)results.get("top_ecm:path");
        JSONArray docs = new JSONArray();
        for (Terms.Bucket b : topField.getBuckets()) {
            if (b.getDocCount() <= 1L) continue;
            JSONObject doc = new JSONObject();
            doc.put((Object)"path", (Object)b.getKey());
            doc.put((Object)"count", (Object)b.getDocCount());
            docs.add((Object)doc);
        }
        duplicatedItems.put((Object)"docs", (Object)docs);
        return new StringBlob(duplicatedItems.toString(), "application/json");
    }
}

