/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.drive.filter;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.runtime.api.Framework;

public class DriveTokenFilter
implements Filter {
    private static final Log log = LogFactory.getLog(DriveTokenFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String app;
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String tokenLoginName = null;
        CacheService cs = (CacheService)Framework.getService(CacheService.class);
        CacheAttributesChecker tokensCache = cs.getCache("ottc-volatile-drive-token-cache");
        if (StringUtils.isNotBlank((String)httpRequest.getHeader("x-authentication-token")) && "Nuxeo Drive".equals(app = httpRequest.getHeader("x-application-name")) && StringUtils.isNotBlank((String)(tokenLoginName = httpRequest.getHeader("x-user-id")))) {
            String keyCache = "Nx-Drive-T-" + tokenLoginName;
            String[] tokenInfos = new String[]{httpRequest.getHeader("x-authentication-token"), httpRequest.getHeader("x-device-id")};
            tokensCache.put(keyCache, (Serializable)tokenInfos);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

