/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ArrayEnumeration<ELEMENTTYPE>
implements Enumeration<ELEMENTTYPE> {
    private ELEMENTTYPE[] m_aArray;
    private int m_nIndex;

    public ArrayEnumeration(ELEMENTTYPE ... ELEMENTTYPEArray) {
        this(ELEMENTTYPEArray, 0, ELEMENTTYPEArray.length);
    }

    public ArrayEnumeration(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(ELEMENTTYPEArray, "Array");
        ValueEnforcer.isGE0(n, "StartIndex");
        ValueEnforcer.isGE0(n2, "Length");
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(ELEMENTTYPEArray, n, n2);
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_nIndex < this.m_aArray.length;
    }

    @Override
    @Nullable
    public ELEMENTTYPE nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ELEMENTTYPE = this.m_aArray[this.m_nIndex];
        ++this.m_nIndex;
        return ELEMENTTYPE;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayEnumeration)) {
            return false;
        }
        ArrayEnumeration arrayEnumeration = (ArrayEnumeration)object;
        return EqualsUtils.equals(this.m_aArray, arrayEnumeration.m_aArray) && this.m_nIndex == arrayEnumeration.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", this.m_aArray).append("index", this.m_nIndex).toString();
    }
}

