/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.seam;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.preview.helper.PreviewHelper;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

@Name(value="previewActions")
@Scope(value=ScopeType.CONVERSATION)
public class PreviewActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PreviewActionBean.class);
    public static final String PREVIEW_POPUP_VIEW = "preview_popup";
    @In(create=true, required=false)
    transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected WebActions webActions;
    @RequestParameter
    private String fieldXPath;
    @RequestParameter
    private String previewTabId;
    private String fieldXPathValue;

    public boolean getHasPreview() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.documentHasPreview(currentDocument);
    }

    public boolean documentHasPreview(DocumentModel document) {
        if (document == null) {
            return false;
        }
        if (PreviewHelper.typeSupportsPreview(document)) {
            try {
                return PreviewHelper.docHasBlobToPreview(document);
            }
            catch (PreviewException e) {
                return false;
            }
        }
        return false;
    }

    public String getPreviewURL() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return null;
        }
        return this.getPreviewURL(currentDocument);
    }

    public String getPreviewURL(DocumentModel doc) {
        return PreviewHelper.getPreviewURL(doc, this.fieldXPathValue);
    }

    public String getPreviewURL(DocumentModel doc, String field) {
        return PreviewHelper.getPreviewURL(doc, this.protectField(field));
    }

    public String getPreviewWithBlobPostProcessingURL() {
        String url = this.getPreviewURL();
        url = url + "?blobPostProcessing=true";
        return url;
    }

    public String getPreviewWithBlobPostProcessingURL(DocumentModel doc) {
        String url = this.getPreviewURL(doc);
        url = url + "?blobPostProcessing=true";
        return url;
    }

    public String getCurrentDocumentPreviewPopupURL() {
        return this.getPreviewPopupURL(this.navigationContext.getCurrentDocument());
    }

    public String getPreviewPopupURL(DocumentModel doc) {
        return this.getPreviewPopupURL(doc, false);
    }

    public String getPreviewPopupURL(DocumentModel doc, boolean newConversation) {
        DocumentLocationImpl docLocation = new DocumentLocationImpl(doc.getRepositoryName(), doc.getRef());
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLocation, PREVIEW_POPUP_VIEW);
        docView.setPatternName("id");
        URLPolicyService urlPolicyService = (URLPolicyService)Framework.getLocalService(URLPolicyService.class);
        String url = urlPolicyService.getUrlFromDocumentView((DocumentView)docView, null);
        if (!newConversation) {
            url = RestHelper.addCurrentConversationParameters((String)url);
        }
        return VirtualHostHelper.getContextPathProperty() + "/" + url;
    }

    @WebRemote
    public String getPreviewPopupURL(String docId) {
        try {
            DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
            return this.getPreviewPopupURL(doc, true);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            return "";
        }
    }

    @Observer(value={"documentSelectionChanged", "documentChanged"}, create=false)
    @BypassInterceptors
    public void resetFields() {
        this.fieldXPathValue = null;
    }

    public String doSetFieldXPath() throws ClientException {
        if (this.fieldXPath != null) {
            this.fieldXPathValue = this.protectField(this.fieldXPath);
        }
        return this.webActions.setCurrentTabAndNavigate(this.previewTabId);
    }

    protected String protectField(String field) {
        return field.replace("/", "-");
    }
}

