/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.gfx;

import com.phloc.commons.collections.LRUCache;
import com.phloc.commons.gfx.ScalableSize;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.state.EChange;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.StatisticsManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ImageDataManager {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ImageDataManager.class);
    private static final IStatisticsHandlerCache s_aStatsHdl = StatisticsManager.getCacheHandler(ImageDataManager.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<IReadableResource, ScalableSize> s_aImageData = new LRUCache<IReadableResource, ScalableSize>(1000);
    private static final Set<IReadableResource> s_aNonExistingResources = new HashSet<IReadableResource>();
    private static final ImageDataManager s_aInstance = new ImageDataManager();

    private ImageDataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ScalableSize _readImageData(@Nonnull IInputStreamProvider iInputStreamProvider) {
        ScalableSize scalableSize = null;
        InputStream inputStream = null;
        try {
            inputStream = iInputStreamProvider.getInputStream();
            if (inputStream != null) {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage != null) {
                    scalableSize = new ScalableSize(bufferedImage.getWidth(), bufferedImage.getHeight());
                } else {
                    s_aLogger.warn("Does not seem to be an image resource: " + iInputStreamProvider);
                }
            } else {
                s_aLogger.warn("Failed to resolve image resource: " + iInputStreamProvider);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            s_aLogger.error("Seems like no AWT binding is present", (Throwable)unsatisfiedLinkError);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            s_aLogger.error("Seems like no AWT binding is present", (Throwable)noClassDefFoundError);
        }
        catch (IIOException iIOException) {
            s_aLogger.error("Failed to interprete image data from resource " + iInputStreamProvider + ": " + iIOException.getMessage());
        }
        catch (IOException iOException) {
            s_aLogger.error("Failed to read image data from resource " + iInputStreamProvider, (Throwable)iOException);
        }
        catch (AccessControlException accessControlException) {
            s_aLogger.error("Whatsoever on " + iInputStreamProvider, (Throwable)accessControlException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            s_aLogger.error("Failed to read image data from resource " + iInputStreamProvider + ": " + illegalArgumentException.getMessage());
        }
        finally {
            StreamUtils.close(inputStream);
        }
        return scalableSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ScalableSize getImageSize(@Nullable IReadableResource iReadableResource) {
        ScalableSize scalableSize;
        if (iReadableResource == null) {
            return null;
        }
        s_aRWLock.readLock().lock();
        try {
            scalableSize = s_aImageData.get(iReadableResource);
            if (scalableSize != null) {
                s_aStatsHdl.cacheHit();
                ScalableSize scalableSize2 = scalableSize;
                return scalableSize2;
            }
            if (s_aNonExistingResources.contains(iReadableResource)) {
                s_aStatsHdl.cacheHit();
                ScalableSize scalableSize3 = null;
                return scalableSize3;
            }
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        scalableSize = ImageDataManager._readImageData(iReadableResource);
        s_aRWLock.writeLock().lock();
        try {
            if (scalableSize == null) {
                s_aNonExistingResources.add(iReadableResource);
            } else {
                s_aImageData.put(iReadableResource, scalableSize);
            }
            s_aStatsHdl.cacheMiss();
            ScalableSize scalableSize4 = scalableSize;
            return scalableSize4;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange clearCachedSize(@Nullable IReadableResource iReadableResource) {
        if (iReadableResource != null) {
            s_aRWLock.writeLock().lock();
            try {
                if (s_aImageData.remove(iReadableResource) != null) {
                    EChange eChange = EChange.CHANGED;
                    return eChange;
                }
                if (s_aNonExistingResources.remove(iReadableResource)) {
                    EChange eChange = EChange.CHANGED;
                    return eChange;
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return EChange.UNCHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange clearCache() {
        s_aRWLock.writeLock().lock();
        try {
            if (s_aImageData.isEmpty() && s_aNonExistingResources.isEmpty()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            s_aImageData.clear();
            s_aNonExistingResources.clear();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was cleared: " + ImageDataManager.class.getName());
            }
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }
}

