/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.CGlobal;
import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.math.MathHelper;
import com.phloc.commons.mutable.IMutableNumeric;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableBigInteger
extends Number
implements IMutableNumeric<MutableBigInteger> {
    public static final BigInteger DEFAULT_VALUE = BigInteger.ZERO;
    private BigInteger m_aValue;

    public MutableBigInteger() {
        this(DEFAULT_VALUE);
    }

    public MutableBigInteger(@Nonnull BigInteger bigInteger) {
        this.m_aValue = ValueEnforcer.notNull(bigInteger, "Value");
    }

    @Nonnull
    public BigInteger getAsBigInteger() {
        return this.m_aValue;
    }

    @Override
    public double doubleValue() {
        return this.m_aValue.doubleValue();
    }

    @Nonnull
    public Double getAsDouble() {
        return this.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.m_aValue.floatValue();
    }

    @Override
    public int intValue() {
        return this.m_aValue.intValue();
    }

    @Override
    public long longValue() {
        return this.m_aValue.longValue();
    }

    @Nonnull
    public BigInteger inc() {
        return this.inc(BigInteger.ONE);
    }

    @Nonnull
    public BigInteger inc(@Nonnull BigInteger bigInteger) {
        this.m_aValue = this.m_aValue.add(bigInteger);
        return this.m_aValue;
    }

    @Nonnull
    public BigInteger dec() {
        return this.inc(CGlobal.BIGINT_MINUS_ONE);
    }

    @Nonnull
    public BigInteger dec(@Nonnull BigInteger bigInteger) {
        return this.inc(bigInteger.negate());
    }

    @Nonnull
    public EChange set(@Nonnull BigInteger bigInteger) {
        if (EqualsUtils.equals(bigInteger, this.m_aValue)) {
            return EChange.UNCHANGED;
        }
        this.m_aValue = bigInteger;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return MathHelper.isEqualToZero(this.m_aValue);
    }

    @Override
    public boolean isNot0() {
        return MathHelper.isNotEqualToZero(this.m_aValue);
    }

    @Override
    public boolean isSmaller0() {
        return MathHelper.isLowerThanZero(this.m_aValue);
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return MathHelper.isLowerOrEqualThanZero(this.m_aValue);
    }

    @Override
    public boolean isGreater0() {
        return MathHelper.isGreaterThanZero(this.m_aValue);
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return MathHelper.isGreaterOrEqualThanZero(this.m_aValue);
    }

    @Override
    public int compareTo(@Nonnull MutableBigInteger mutableBigInteger) {
        return this.m_aValue.compareTo(mutableBigInteger.m_aValue);
    }

    @Override
    @Nonnull
    public MutableBigInteger getClone() {
        return new MutableBigInteger(this.m_aValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableBigInteger)) {
            return false;
        }
        MutableBigInteger mutableBigInteger = (MutableBigInteger)object;
        return EqualsUtils.equals(this.m_aValue, mutableBigInteger.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).toString();
    }
}

